<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\SearchResource;
use App\Http\Resources\UserResource;
use App\Models\City;
use App\Models\Country;
use App\Models\Nationality;
use App\Models\Notification;
use App\Models\Region;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function update_profile(Request $request)
    {
        $user = auth()->user();


        $user->update([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'mobile' => $request->mobile,
            'nationality_id' => $request->nationality_id,
            'birthdate' => $request->birthdate,
            'country_id' => $request->country_id,
            'city_id' => $request->city_id,
            'region_id' => $request->region_id,
            'address' => $request->address,
            'about' => $request->about,
            'website' => $request->website,
            'facebook' => $request->facebook,
            'instgram' => $request->instgram,
            'youtube' => $request->youtube,
        ]);
        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_image(Request $request)
    {

        if($request->hasFile('image')){
            $image = $request->file('image');
            $image_name = Time().'-'.$image->getClientOriginalName();
            $file_path = public_path().'/images';
            $image->move($file_path,$image_name);
        }

        $user = auth()->user();
        $user->update(['image'=> $image_name]);


        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_background_image(Request $request)
    {
        $user = auth()->user();
        if($request->hasFile('background_image')){

            $background_image = $request->file('background_image');
            $background_image_name = Time().'-'.$background_image->getClientOriginalName();
            $background_image_path = public_path().'/images';
            $background_image->move($background_image_path,$background_image_name);
        }

        $user = auth()->user();
        $user->update(['background_image'=> $background_image_name]);

        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_interests(Request $request)
    {
        $user = auth()->user();

        $user->interests()->sync($request->interests);

        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function notifications()
    {
        $user = auth()->user();
        $notifications = Notification::select('id','title','body','user_id','created_at')->where('user_id',$user->id)->orWhere('user_id',-1)->get();

        foreach($notifications as $notification){
            $notification->added_at = date('d-m-Y h:m', strtotime($notification->created_at))."";
        }
        return $this->apiResponse(200, null, $notifications);
    }



    public function user_info(Request $request)
    {
        $user = User::where('id',$request->user_id)->first();
        $user['age'] = Carbon::parse($user['birthdate'])->age;
        return $this->apiResponse(200, null, new UserResource($user));
    }

    public function follow_profile(Request $request)
    {
           $user = auth()->user();
        if($user->following->contains($request->following_id)){
           $user->following()->detach($request->following_id);
        return $this->apiResponse(200,null,null);
        }
        else {
            $user->following()->attach($request->following_id);
        return $this->apiResponse(200,null, null);
        }
    }

    public function user_followers(Request $request)
    {
          $user = auth()->user();
          $followers = $user->followers;
          return $this->apiResponse(200, null, new UserResource($followers));
    }

    public function follow_users(Request $request)
    {
          $user = auth()->user();
          foreach ($request->follows as $follow) {
            $user->following()->attach($follow);
          }
          return $this->apiResponse(200, null, null);
    }


    public function add_crew(Request $request)
    {
          $user = auth()->user();
          $user->crew()->attach($request->crew_id,['title_id' => $request->title_id]);
          return $this->apiResponse(200, null, $user->crew);
    }

    public function remove_from_crew(Request $request)
    {
          $user = auth()->user();
          $user->crew()->detach($request->crew_id);
          return $this->apiResponse(200, null, $user->crew);
    }

    public function my_crew()
    {
          $user = auth()->user();
          $crew = $user->crew;
          return $this->apiResponse(200, null, $crew);
    }


    public function search(Request $request)
    {
        $query = User::query();
        if($request->keyword){
         $users = $query->where('name','like','%'.$request->keyword.'%')->get();
         return $this->apiResponse(200, null, SearchResource::collection($users));
             }
    }


    public function countries()
    {
         $countries = Country::select('id','name')->get();
         return $this->apiResponse(200, null, $countries);
    }

    public function cities()
    {
         $cities = City::select('id','name')->get();
         return $this->apiResponse(200, null, $cities);
    }

    public function nationalities()
    {
         $nationalities = Nationality::select('id','name')->get();
         return $this->apiResponse(200, null, $nationalities);
    }

    public function regions()
    {
         $regions = Region::select('id','name')->get();
         return $this->apiResponse(200, null, $regions);
    }



   public function random_users()
   {


       $users = User::select('id','name','image','type')->limit(50)->get();

       foreach($users as $user){
           $user->image =  asset('images/').'/'. $user->image ;
       }
      return $this->apiResponse(200,null, $users);

  }




}
