<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\PostResource;
use App\Models\Image;
use App\Models\Post;
use App\Models\User;
use App\Models\VonHistory;
use Illuminate\Http\Request;

class PostController extends Controller
{
   public function get_posts()
   {
       $user = auth()->user();
       $posts = Post::latest()->paginate(15);

       foreach($posts as $post){
        $post->added_at = $post->created_at->diffForHumans();
        $images = Image::where('post_id',$post->id)->get();
        $post->is_liked = $user->likes->contains($post->id);
        $post['images'] =  $images;
        }

        // return   $posts;
        $results = PostResource::collection($posts);

        // $results['images'] =

       return $this->apiResponse(200,null, $results);
   }


   public function show_post(Request $request)
   {
    $user = auth()->user();
       $post = Post::find($request->post_id);
       $post->is_liked = $user->likes->contains($post->id);

       return $this->apiResponse(200,null, new PostResource($post));
   }


   public function new_post(Request $request)
   {
    if($request->hasFile('media')){

        $media = $request->file('media');
        $file_name = Time().'-'.$media->getClientOriginalName();
        $file_path = public_path().'/media';
        $media->move($file_path,$file_name);
    }
       $post = Post::create([
        'text' => $request->text,
        'media_type' => $request->media_type,
        'media' => $file_name ?? null,
        'privacy' => $request->privacy,
        'user_id' => auth()->user()->id,
       ]);

       if($request->hasFile('images')){

        foreach ($request->file('images') as $image) {
            $file_name = Time().'-'.$image->getClientOriginalName();
            $file_path = public_path().'/images';
            $image->move($file_path,$file_name);
            $new_image = Image::create(['name'=>$file_name , 'post_id' =>  $post->id]);
        }
    }
       return $this->apiResponse(200,'post is created', new PostResource($post));
   }


   public function edit_post(Request $request)
   {
    $user = auth()->user();
    $post = Post::find($request->post_id);

    if($post->user_id == $user->id){

        if($request->hasFile('media')){

            $media = $request->file('media');
            $file_name = Time().'-'.$media->getClientOriginalName();
            $file_path = public_path().'/media';
            $media->move($file_path,$file_name);
        }

        $post->update([
            'text' => $request->text,
            'media_type' => $request->media_type,
            'media' => $file_name ?? null,
            'privacy' => $request->privacy,
        ]);

        if($request->hasFile('images')){

            foreach ($request->file('images') as $image) {
                $file_name = Time().'-'.$image->getClientOriginalName();
                $file_path = public_path().'/images';
                $image->move($file_path,$file_name);
                $new_image = Image::create(['name'=>$file_name , 'post_id' => $post->id ]);
            }
        }
        return $this->apiResponse(200,'post is updated', new PostResource($post));
    }
        return $this->apiResponse(200, 'you cant edit this post', new PostResource($post));
   }


   public function delete_post(Request $request)
   {
       $post = Post::find($request->post_id);
       if($post){
        $post->delete();
        return $this->apiResponse(200,'post is deleted', new PostResource($post));
       }
   }


   public function show_vons()
    {
        $user = auth()->user();

        $vons = VonHistory::select('user_id','text','created_at')->paginate(50);

        foreach($vons as $von){
            $von->added_at = $von->created_at->diffForHumans();
            $von->user = User::select('id','name','image','type')->where('id',$von->user_id)->first();
            $von->user->image =  asset('images/').'/'. $von->user->image ;
            $von->user->is_follow = $user->following->contains($von->user_id);
        }
       return $this->apiResponse(200,null, $vons);

   }


   public function post_like(Request $request)
    {
        $user = auth()->user();
        if($user->likes->contains($request->post_id)){
            $user->likes()->detach($request->post_id);
            return $this->apiResponse(200, null, new PostResource(Post::find($request->post_id)));
        }
        else {
            $user->likes()->attach($request->post_id);
            return $this->apiResponse(200,null, new PostResource(Post::find($request->post_id)));
        }
    }

   public function post_by_user(Request $request)
    {
        $posts = Post::where('user_id',$request->user_id)->get();
        return $this->apiResponse(200, null,  PostResource::collection($posts));
    }



}
