<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\AlbumMediaResource;
use App\Http\Resources\AlbumResource;
use App\Http\Resources\CameraResource;
use App\Http\Resources\CrewResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\LensResource;
use App\Http\Resources\UserResource;
use App\Models\Album;
use App\Models\AlbumMedia;
use App\Models\Camera;
use App\Models\Crew;
use App\Models\JobTitle;
use App\Models\Lens;
use App\Models\User;
use Illuminate\Http\Request;

class MediaController extends Controller
{
    public function get_media_data(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        $crews   = $user->crew;
        $lens    = $user->lenses;
        $cameras = $user->cameras;

        return $this->apiResponse(200 , null , [
          'cameras' =>  CameraResource::collection($cameras),
          'crews' => CrewResource::collection($crews),
          'lenses' =>  LensResource::collection($lens),
        ]);
    }


    public function get_media_by_type(Request $request)
    {
           $media = AlbumMedia::where('type',$request->type)->get();

           return $this->apiResponse(200 , null , AlbumMediaResource::collection($media));

    }

    public function get_albums(Request $request)
    {
          $user = User::findOrFail($request->user_id);
          $albums =  Album::with('images')->where('user_id',$user->id)->get();

          foreach ( $albums as $album) {
            if(count($album->images) > 0){
             $image =  $album->images[0]->media;
             $album['image'] =  $image;
            }
            $albums = AlbumResource::collection( $albums);

          }
        return $this->apiResponse(200 , null ,$albums );
    }

    public function get_album_images(Request $request)
    {
        $album = Album::findOrFail($request->album_id);
        $images = $album->images;
        return $this->apiResponse(200 , null , ImageResource::collection($images));
    }

    public function get_cameras()
    {
        $cameras = Camera::get();
        return $this->apiResponse(200 , null ,  CameraResource::collection($cameras));
    }

    public function get_lenses()
    {
        $lenses = Lens::get();
        return $this->apiResponse(200 , null ,  LensResource::collection($lenses));
    }

    public function add_new_camera(Request $request)
    {
         $user = auth()->user();
         $user->cameras()->attach($request->camera_id);
         return $this->apiResponse(200 , null , null);
    }

    public function remove_camera(Request $request)
    {
         $user = auth()->user();
         $user->cameras()->detach($request->camera_id);
         return $this->apiResponse(200 , null , null);
    }

    public function add_new_album(Request $request)
    {
     if($request->hasFile('image')){

        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        $user = auth()->user();
        $album = Album::create(['name' => $request->name , 'user_id' => $user->id]);

        AlbumMedia::create([
            'album_id' => $album->id,
            'type' => 'image',
            'media' => $file_name,
        ]);
        return $this->apiResponse(200 , null ,null);
    }

    public function add_album_media(Request $request)
    {
        foreach($request->media as $item){

            $file_name = Time().'-'.$item->getClientOriginalName();
            $file_path = public_path().'/media';
            $item->move($file_path,$file_name);

           $media = AlbumMedia::create([
                'album_id' => $request->album_id,
                'type' => $request->type,
                'media' => $file_name,
            ]);
        }
        return $this->apiResponse(200 , null , $media);
    }

    public function add_lens(Request $request)
    {
        $user = auth()->user();
       $lens =  $user->lenses()->attach($request->lens_id);
        return $this->apiResponse(200 , null , $lens);
    }

    public function remove_lens(Request $request)
    {
        $user = auth()->user();
       $lens =  $user->lenses()->detach($request->lens_id);
        return $this->apiResponse(200 , null , $lens);
    }

    public function job_titles(Request $request)
    {
       $titles =  JobTitle::where('type',$request->type)->get();
        return $this->apiResponse(200 , null , $titles);
    }




}

