<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\CommentResource;
use App\Http\Resources\PostResource;
use App\Models\Comment;
use App\Models\Post;
use Illuminate\Http\Request;

class CommentController extends Controller
{
    public function comments(Request $request)
    {
        $comments =  Post::find($request->post_id)->comments;
        return $this->apiResponse(200,null, CommentResource::collection($comments));
    }


    public function new_comment(Request $request)
    {
        $comment = Comment::create([
         'text' => $request->text,
         'post_id' => $request->post_id,
         'user_id' => auth()->user()->id,
        ]);
        return $this->apiResponse(200,'comment is created', new CommentResource($comment));
    }


    public function edit_comment(Request $request)
    {
     $user = auth()->user();
     $comment = Comment::find($request->comment_id);
  if($comment->user_id == $user->id){
     $comment->update(['text' => $request->text ,  $user->id ]);

         return $this->apiResponse(200,'comment is updated', new CommentResource($comment));
     }
         return $this->apiResponse(200, 'you cant edit this comment', new CommentResource($comment));
    }


    public function delete_comment(Request $request)
    {
        $comment = Comment::findOrFail($request->comment_id);
        if($comment->user_id == auth()->user()->id){
         $comment->delete();
         return $this->apiResponse(200,'comment is deleted', new CommentResource($comment));
        }
        return $this->apiResponse(401,'you cant delete this comment', new CommentResource($comment));

    }
}
