<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CareerMember extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $fillable = ['member_id','career_id'];
    
    public function user()
    {
        return $this->belongsTo(User::class, 'member_id', 'id');
    }
    
    
    public function career()
    {
        return $this->belongsTo(User::class, 'career_id', 'id');
    }
}
