<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ClubResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'owner' => $this->owner?$this->owner->name:"",
            'president' => $this->president?$this->president->name:"",
            'vice_president' =>  $this->vice_president?$this->vice_president->name:"",
            'manager' => $this->manager?$this->manager->name:"",
            'communication_director' => $this->communication_director?$this->communication_director->name:"",
            'assistant' => $this->assistant?$this->assistant->name:"",
            'facilitator' => $this->facilitator?$this->facilitator->name:"",
            'marcher' => $this->marcher?$this->marcher->name:"",
            'instructor' => $this->instructor?$this->instructor->name:"",
            'team_leader' => $this->team_leader?$this->team_leader->name:"",
            'owner_id' => $this->owner?$this->owner->id:0,
            'president_id' => $this->president?$this->president->id:0,
            'vice_president_id' => $this->vice_president?$this->vice_president->id:0,
            'manager_id' => $this->manager?$this->manager->id:0,
            'communication_director_id' => $this->communication_director?$this->communication_director->id:0,
            'assistant_id' => $this->assistant?$this->assistant->id:0,
            'facilitator_id' => $this->facilitator?$this->facilitator->id:0,
            'marcher_id' => $this->marcher?$this->marcher->id:0,
            'instructor_id' => $this->instructor?$this->instructor->id:0,
            'team_leader_id' => $this->team_leader?$this->team_leader->id:0,
            'members' => $this->members,
        ];
    }
}
