<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\JsonResponse;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'POST': {
                return [
                    'name' => 'required',
                    'email' => 'required|email',
                    'password' => 'required|min:6|confirmed',
                    'mobile' => 'nullable',
                ];
            }

            case 'PUT': {
                return [
                    'name' => 'required',
                    'email' => 'required|email',
                    'password' => 'required|min:6|confirmed',
                    'mobile' => 'nullable',
                ];
            }
        }
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $response = new JsonResponse([
                    'status_code' => 422 ,
                    'message' => $validator->errors(),
                ], 200);

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }
}
