<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Champion;
use App\Models\Category;
use App\Models\User;
use App\Models\ChampionCrew;
use App\Models\Job;
use App\Models\JobTitle;
use App\Models\Course;
use App\Models\CourseUser;
use App\Models\Event;
use App\Models\VonHistory;
use App\Models\EventCrew;
use App\Models\VenueMember;
use App\Models\Venue;
use App\Models\VenueEvent;
use App\Models\VenueEventMember;
use App\Models\Notification;




class VenueController extends Controller
{
    
    
    
    public function venues(Request $request)
     {
        $venues = Venue::select('id','type','image','category_id','category_ids','user_id','length','turns_number','best_record_user_id','fia_grade','race_capacity','audience_capacity','lat','lng','best_record_hours','best_record_minutes','best_record_seconds')->where('user_id',$request->user_id)->get();
            
     
        
        foreach($venues as $venue){
            
          $sponsers = array();
          $partners = array();
          $crews    = array();
            
            $venue->image = asset('images/').'/'.$venue->image;
            $venue->category = Category::select('id','name')->where('id',$venue->category_id)->first();
            
            
            $categories =  Category::select('id','name')->whereIn('id',explode( ',', $venue->category_ids ))->get();
            
            $categories_string = "";
            $is_first = true;
            
            foreach($categories as $cat){
                
                if(!$is_first){
                $categories_string.=",";
                }
                $is_first=false;
                 $categories_string.=$cat->name;
                 
            }
            
            $venue->categories = $categories_string;
            
            
            $venue_members = VenueMember::select('id','member_id','title_id','type')->where('status',1)->where('venue_id',$venue->id)->get();
            
            $venue->best_record = User::where('id',$venue->best_record_user_id)->first();
            
         
            
            if($venue->best_record)
            {$venue->best_record=$venue->best_record->name;
            }
            
              

            if($venue->type==0){
               $venue->type="Vehicle";
            }
            else if($venue->type==1){
                $venue->type="Motorcycle";
            }else {
                $venue->type="Both"; 
                }
                
                $venue->best_record_venue = User::select('id','name')->where('id',$venue->best_record_user_id)->first();
                
                
                //dd($venue_members);
                
            foreach($venue_members as $venue_member){
                
                $user = User::select('id','name')->where('id',$venue_member->member_id)->first();
                
                 if($user){
                     
                       if($venue_member->type==1){
                          array_push($sponsers,$user);
                       }else if($venue_member->type==2){
                           array_push($partners,$user);
                          
                          }else {
                              
                               $user->title_id =$venue_member->title_id;
                               
                              
                               
                               $user->title=JobTitle::select('id','name')->where('id',$venue_member->title_id)->first()->name;
                               
                                
                            array_push($crews,$user);
                          }
            
                    }
                    
                  
            }
            
            
            $venue->crews = $crews;
            $venue->sponsers = $sponsers;
            $venue->partners = $partners;
            
        }
        
        return $this->apiResponse(200 , null , $venues);
     }
     
     
     
  public function save_venue(Request $request) {
         
         $user = auth()->user();
         
     
          $crews_title_ids = explode(",",$request->crew_title_ids) ;
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
          $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
        
        
        if( (!$request->category_ids) && $request->category_id==-1){
         $category = Category::create([ 'name'=> $request->category , 'type'=> $request->type]);
         $request->category_id = $category->id;
        }
         
                 
        $event = Venue::create([
            'name' => $request->name,
            'category_id'=> $request->category_id,
            'category_ids'=> $request->category_ids,
            'fia_grade'=> $request->fia_grade,
            'audience_capacity'=> $request->audience_capacity,
            'type'=> $request->type,
            'lat'=> $request->lat,
            'lng'=> $request->lng,
            'length'=> $request->length,
            'turns_number'=> $request->turns_number,
            'race_capacity'=> $request->racer_capacity,
            'audience_capacity'=> $request->audience_capacity,
            'best_record_user_id'=> $request->best_record_user_id,
            'best_record_hours'=> $request->best_record_hours,
            'best_record_minutes'=> $request->best_record_minutes,
            'best_record_seconds'=> $request->best_record_seconds,
            'type'=> $request->type,
            'user_id'=>$user->id,
            'image'=>$image_name,
            
            ]);
            
            
         $notification_title = "Venue Best Record";
         
        $notification_body = $user->name.' invited you to as a venue best record';
        
         $tokens = User::where('id',$request->best_record_user_id)->pluck('google_id');
         
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $request->best_record_user_id,
                   'notification_type'=>1
                   ]);
                   
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		 $this->send_multi_notification($tokens,$message_complete);
		 
        
        $von_text = $user->name." has added their venue details";    
        
        VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'create_venue' ]);
         
            
        if($sponsor_ids){
            
        $notification_title = "Venue Sponser";
        $notification_body = $user->name.' invited you to as a sponsor to his Venue';
                 
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           VenueMember::create([
            'venue_id' => $event->id,
            'member_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
        
          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $sponsor_ids[$i],
                   'notification_type'=>2
                   ]); 
        }

         $tokens = User::whereIn('id',$sponsor_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>"Venue sponsor",'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
        }

         
         if($partners_ids){
             
          $notification_title = "Venue partner";
         $notification_body = $user->name.' invited you to as a partner to his Venue';
         
         
         for($i=0; $i<count($partners_ids); $i++){   
            
           VenueMember::create([
            'venue_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            

          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $partners_ids[$i],
                   'notification_type'=>3
                   ]); 
            
        }
        
        $tokens = User::whereIn('id',$partners_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>"Venue partner",'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
         }
        
        if($crews_ids){
            
                  $notification_title = "Venue crew member";
            
          $notification_body = $user->name.'  invited you to crew members to his Venue';
        
         for($i=0; $i<count($crews_ids); $i++){   
             
                VenueMember::create([
                  'venue_id' => $event->id,
                  'member_id'=> $crews_ids[$i],
                  'title_id'=> $crews_title_ids[$i],
                  'type'=>3
                     ]);
            
                  Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                   'notification_type'=>4
                   ]); 
                   
                     
           }
           
           
         $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>"Venue partner",'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
		 
           
        }
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
     
   public function update_venue(Request $request)
      
   {
         
         $user = auth()->user();
         
     
          $crews_title_ids = explode(",",$request->crew_ids) ;
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
          
          $event = Venue::where('id',$request->venue_id)->first();
          
         $image_name="";
             
        if($request->hasFile('image')){
         $image = $request->file('image');
         $image_name = time() . '-' . $image->getClientOriginalName();
         $image_path = public_path().'/images';
         $image->move($image_path,$image_name);
               $event->image = $image_name;
         }
        
        
        if($request->category_id==-1){
         $category = Category::create([ 'name'=> $request->category , 'type'=> $request->type]);
         $request->category_id = $category->id;
        }
        
        
         //$event->name = $request->name;
         $event->category_ids = $request->category_ids;
         $event->category_id = $request->category_id;
         $event->fia_grade = $request->fia_grade;
         $event->audience_capacity = $request->audience_capacity;
         $event->type = $request->type;
         $event->lat = $request->lat;
         $event->lng = $request->lng;
         $event->length = $request->length;
         $event->turns_number = $request->turns_number;
         $event->race_capacity = $request->racer_capacity;
         $event->best_record_user_id = $request->best_record_user_id;
         $event->best_record_hours = $request->best_record_hours;
         $event->best_record_minutes = $request->best_record_minutes;
         $event->best_record_seconds = $request->best_record_seconds;
         
         
          $von_text = $user->name." has updated their venue details";    
          
         VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'update_venue' ]);
     
 
    $event->save();
            
        VenueMember::where('venue_id',$request->venue_id)->delete();
         
            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           VenueMember::create([
            'venue_id' => $event->id,
            'member_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
        }
        
         for($i=0; $i<count($partners_ids); $i++){   
            
           VenueMember::create([
            'venue_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
        }
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
            
           VenueMember::create([
            'venue_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'title_id'=> $crews_title_ids[$i],
            'type'=>3
            ]);
            
        }
        }
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
    public function venue_events(Request $request)
     {
         
        $venue_events = VenueEvent::select('id','event_maker_id','is_my_event','type','image','name','category_id','user_id','date','description','best_record_user_id','best_record_hours','best_record_minutes','best_record_seconds','racers_count','audiance')->where('user_id',$request->user_id)->get();
        
            
        
        foreach($venue_events as $venue_event){
            
            $sponsers = array();
            $partners = array();
            $racers = array();
            
            
            $venue_event->image = asset('images/').'/'.$venue_event->image;
            $venue_event->category = Category::select('id','name')->where('id',$venue_event->category_id)->first();
            $event_users = VenueEventMember::select('id','member_id','type')->where('status',1)->where('venue_event_id',$venue_event->id)->get();
            
            $venue_event->best_record =  User::select('id','name')->where('id',$venue_event->best_record_user_id)->first();
            
            if($venue_event->best_record){
                
                 $venue_event->best_record = $venue_event->best_record->name;
                 
                   $venue_event->best_record_details =  User::select('id','name')->where('id',$venue_event->best_record_user_id)->first();
            }
        
            
             if($venue_event->event_maker){
                 $venue_event->event_maker = $venue_event->event_maker->name;
         }
         

         if($venue_event->is_my_event == 1){
             $venue_event->is_my_event_text = 'My Event';
             $venue_event->event_maker_id = null;
             
         } else {
             $venue_event->is_my_event_text = 'Hosted Event';
         }
            

             
            
                if($venue_event->type==1){
                        $venue_event->type="Vehicle";
                }else {
                        $venue_event->type="Motorcycle";
                }
                foreach($event_users as $event_user){
                
                $user = User::select('id','name')->where('id',$event_user->member_id)->first();
                
                 if($user){
                     
                       if($event_user->type==1){
                     array_push($sponsers,$user);
                       }else if($event_user->type==2){
                          array_push($partners,$user);
                          }else {
                         array_push($racers,$user);
                          }
            
                    }
                 }
           $venue_event->sponsers = $sponsers;
           $venue_event->partners = $partners;
           $venue_event->racers = $racers;
           
           if($venue_event->is_my_event == 0){
               $venue_event->event_maker = User::select('id','name')->where('id',$venue_event->event_maker_id)->first(); 
           }
          else {
               $venue_event->event_maker = null;
          }
           
            
        }
        
        return $this->apiResponse(200 , null , $venue_events);
     }
     
     
         
  public function save_venue_event(Request $request){
         
         $user = auth()->user();
         

          //$crews_title_ids = explode(",",$request->crews_title_ids) ;
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
     $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
        $event = VenueEvent::create([
            'name' => $request->name,
            'is_my_event' => $request->is_my_event,
            'category_id'=> $request->category_id,
            'type'=> $request->type,
            'description'=> $request->details,
            'best_record_user_id'=> $request->best_record_user_id,
            'best_record_hours'=> $request->best_record_hours,
            'best_record_minutes'=> $request->best_record_minutes,
            'best_record_seconds'=> $request->best_record_seconds,
            'event_maker_id'=> $request->event_maker_id,
            'user_id'=>$user->id,
            'image'=>$image_name,
             'date' => $request->date,
            ]);
            
            
            if($request->is_my_event==1){
            
              $notification_title = "New Event Created";
          $notification_body = $user->name.' invited you join his event '.$request->name.' at ('.$request->date.')';
        
         $tokens = User::where('type','car_racer')->pluck('google_id');
 
 
          $users = User::select('id')->where('type','car_racer')->get();
          
          foreach($users as $user){
              
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $user->id,
                   'notification_type'=>35
                   ]);
                   
          }
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		 $this->send_multi_notification($tokens,$message_complete);
		 
		 
		 
		  $notification_title = "New Event Created";
          $notification_body = $user->name.' invited you join his event '.$request->name.' at ('.$request->date.')';
        
         $tokens = User::where('type','car_racer')->pluck('google_id');
 
 
          $users = User::select('id')->where('id','!=',$user->id)->where('type','!=','car_racer')->get();
          
          foreach($users as $user){
              
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $user->id,
                   'notification_type'=>36
                   ]);
                   
          }
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		 $this->send_multi_notification($tokens,$message_complete);
		 
		 
		 
            }
		 
        
        $notification_title = "Event Best Record";
        $notification_body = $user->name.' invited you to as event best record in '.$request->name;
         $tokens = User::where('id',$request->best_record_user_id)->pluck('google_id');
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $request->best_record_user_id,
                   'notification_type'=>5
                   ]);
                   
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
		 
            
            
        $von_text = $user->name." has created their new event";            
    
       VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'update_venue_event' ]);
       
       
             if($partners_ids){
       
            $notification_title = "Event sponser";
         $notification_body = $user->name.' invited you to as a sponser to his '.$request->name.' ('.$request->date.')';

            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
               Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $sponsor_ids[$i],
                   'notification_type'=>7
                   ]);
        }
        
        
         $tokens = User::whereIn('id',$partners_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
     }
        
        
        $notification_title = "Event partner";
         $notification_body = $user->name.' invited you to as a partner to his '.$request->name.' ('.$request->date.')';
        
        
         if($partners_ids){
        
         for($i=0; $i<count($partners_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
               Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $partners_ids[$i],
                   'notification_type'=>8
                   ]);
        }
        
        $tokens = User::whereIn('id',$partners_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
		 
         }
         
         
         
        
        if($crews_ids){
            
         $notification_title = "Event crew";
         $notification_body = $user->name.' invited you to as a crew to his '.$request->name.' ('.$request->date.')';
         
        
         for($i=0; $i<count($crews_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'type'=>3
            ]);
            
            
            Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                   'notification_type'=>9
                   ]);
                   
        }
        
               $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
		 
		 
        }
        
        
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
     
     public function update_venue_event(Request $request){
         
         $user = auth()->user();
         

          //$crews_title_ids = explode(",",$request->crews_title_ids) ;
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
              $event = VenueEvent::where('id',$request->venue_event_id)->first();
          
     $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
    
            $event->name = $request->name;
            $event->is_my_event = $request->is_my_event;
            $event->category_id = $request->category_id;
            $event->type = $request->type;
            $event->description = $request->details;
            $event->best_record_user_id = $request->best_record_user_id;
            $event->best_record_hours = $request->best_record_hours;
            $event->best_record_minutes = $request->best_record_minutes;
            $event->best_record_seconds = $request->best_record_seconds;
            $event->event_maker_id = $request->event_maker_id;
            $event->image = $image_name;
            
            
              $von_text = $user->name." has updated their new event";    
            
             VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'update_venue_event' ]);
  
      
      $event->save();
         
            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
        }
        
         for($i=0; $i<count($partners_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
        }
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
            
           VenueEventMember::create([
            'venue_event_id' => $event->id,
            'member_id'=> $crews_ids[$i],
            'type'=>3
            ]);
            
        }
        }
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
     public function user_events(Request $request)
     {
         
        $events = Event::select('id','name','champion_id','audience_capacity','race_capacity','date','lat','long as lng','details','length','turns_number','best_record_user_id','best_record_hours','best_record_minutes','best_record_seconds','image')->where('user_id',$request->user_id)->get();
        
            foreach($events as $event){
                
            $champion = Champion::select('id','name','image','category_id','user_id','type')->where('id',$event->champion_id)->first();
            
            
            $sponsers = array();
            $partners = array();
            $racers = array();
            
            
            $event->best_record = User::select('id','name')->where('id',$event->best_record_user_id)->first();
            
            
           // dd($champion);
                
            $champion->image = asset('images/').'/'.$event->image;
            $champion->category = Category::select('id','name')->where('id',$champion->category_id)->first();
            
            $event_users = EventCrew::where('event_id',$event->id)->get();
            
          
            
            foreach($event_users as $event_user){
                
                $user = User::select('id','name')->where('id',$event_user->crew_id)->first();
                
                  
                  
                 if($user){
                     
                       if($event_user->type==1){
                     array_push($sponsers,$user);
                       }else if($event_user->type==2){
                          array_push($partners,$user);
                          }else {
                         array_push($racers,$user);
                          }
            
                    }
            }
            
            $event->sponsers = $sponsers;
            $event->partners = $partners;
            $event->racers = $racers;
            
            if($champion->type==1){
              $champion->type="Vehicle";
            }else {
                    $champion->type="Motorcycle";
                }
                
            
            $event->champion = $champion;
                
                
            }
 
        return $this->apiResponse(200 , null , $events);
     }
     
     
    public function club_members()
     {
        $clubs = ClubMember::get();
        return $this->apiResponse(200 , null ,ClubMemberResource::collection($clubs));
     }
     
     
    public function save_club(Request $request)
     {
        $club = Club::create([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function save_club_member(Request $request)
    {
        $member = ClubMember::create([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function update_club(Request $request)
     {
         $club = Club::where('id',$request->club_id)->first();
         
         $club->update([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function update_club_member(Request $request)
    {
        $member = ClubMember::where('id',$request->club_member_id)->first();

        $member->update([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    
    public function delete_venue(Request $request)
     {
             $venue = Venue::where('id',$request->venue_id)->first();
        $venue->delete();
        return $this->apiResponse(200 , "venue is deleted" , null);
     }
     
     public function delete_venue_event(Request $request)
     {
        $venue = VenueEvent::where('id',$request->venue_event_id)->first();
        $venue->delete();
        return $this->apiResponse(200 , "venue event is deleted" , null);
     }
     
     
    public function delete_club_member(Request $request)
    {
        $venue = Venue::where('id',$request->venue_id)->first();
        $venue->delete();
        return $this->apiResponse(200 , "venue is deleted" , null);
    }
    
        function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
}
