<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\AlbumResource;
use App\Http\Resources\CameraResource;
use App\Http\Resources\CrewResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\LensResource;
use App\Http\Resources\UserResource;
use App\Http\Resources\EventResource;
use App\Models\Album;
use App\Models\Camera;
use App\Models\Crew;
use App\Models\Event;
use App\Models\Lens;
use App\Models\User;
use Illuminate\Http\Request;

class EventsController extends Controller
{
    public function get_events()
    {
            $events = Event::get();
    foreach($events as $event){
            $event->image = asset('images/').'/'.$event->image;
    }
     return $this->apiResponse(200 , null ,$events);
    }
    
    
    public function filter_events(Request $request)
    {
       
            $events = Event::select('id','name','details','lat','long','date','image');
            
            if($request->type_id > 0 ){
               $events =   $events->where('type',$request->type_id);
            }
            
            
            if($request->categories ){
            
                $events=$events->whereIn('category', explode(",", $request->categories)  );
            }
            
             if($request->start_date && $request->end_date ){
            $from = date($request->start_date);
            $to = date($request->end_date);
            
            // dd($request->end_date );
            
            $events = $events->whereBetween('date', [$from, $to]);
             }
             
             
            
            $events = $events->get();
            
            
    foreach($events as $event){
            $event->image = asset('images/').'/'.$event->image;
    }
    
    
     return $this->apiResponse(200 , null ,$events);
    }
    
    
     public function search_events(Request $request)
    {
       
            $events=null;
            
            $query = Event::query();
           
        if($request->keyword){
           $events = $query->select('id','name')->where('name','like','%'.$request->keyword.'%')->get();
        }
     return $this->apiResponse(200 , null ,$events);
    }
    
    
    
    
    public function get_user_events(Request $request)
    {
        $events = Event::where('user_id',$request->user_id)->get();
        return $this->apiResponse(200 , null , EventResource::collection($events));
    }
    
    
    
    public function save_event(Request $request)
    {
        if($request->hasFile('image')){

        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        $user = auth()->user();
        $event = Event::create([
          'name' => $request->name,
          'details'=> $request->details,
          'image'=> $file_name,
          'status'=> $request->status,
          'user_id'=> $user->id,
          'date' => $request->date,
          'street_race_venue' => $request->street_race_venue,
          'lat' => $request->lat,
          'long' => $request->long,
          'shampionship_id' => $request->shampionship_id,
          'racer_capicity' => $request->racer_capicity,
          'audience_capicity' => $request->audience_capicity,
          'length' => $request->length,
          'turns_number' => $request->turns_number,
          'description' => $request->description,
          'sponsor_id' => $request->sponsor_id,
          'partner_id' => $request->partner_id,
          'user_rank' => $request->user_rank,
        ]);
        
        VonHistory::create(['user_id' => $user->id , 'text' => "New Event has been added" , 'von_id' => $event->id , 'von_type' => 'create_event' ]);


        return $this->apiResponse(200 , null , new EventResource($event));
    }
    
    
    
    public function update_event(Request $request)
    {
        $event = Event::where('id',$request->event_id)->first();

     if($request->hasFile('image')){
        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        
        $event->update([
          'name' => $request->name,
          'details'=> $request->details,
          'image'=> $file_name,
          'status'=> $request->status,
          'date' => $request->date,
          'street_race_venue' => $request->street_race_venue,
          'lat' => $request->lat,
          'long' => $request->long,
          'shampionship_id' => $request->shampionship_id,
          'racer_capicity' => $request->racer_capicity,
          'audience_capicity' => $request->audience_capicity,
          'length' => $request->length,
          'turns_number' => $request->turns_number,
          'description' => $request->description,
          'sponsor_id' => $request->sponsor_id,
          'partner_id' => $request->partner_id,
            ]);
            
        return $this->apiResponse(200 , null , new EventResource($event));
    }
    
    

    public function delete_event(Request $request)
    {
        $event = Event::where('id',$request->event_id)->first();
        $event->delete();
        
        return $this->apiResponse(200 , 'event is deleted' , null);
    }
    



}

