<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BrakeKit;
use App\Models\Cam;
use App\Models\Camera;
use App\Models\Car;
use App\Models\CarBrand;
use App\Models\CarCylinder;
use App\Models\CarEngineCc;
use App\Models\CarMake;
use App\Models\CarModel;
use App\Models\CarModelVersion;
use App\Models\CarPlatFormYear;
use App\Models\CarTorque;
use App\Models\CarVersion;
use App\Models\CarYear;
use App\Models\Clutch;
use App\Models\CoilOvers;
use App\Models\ConnectingRods;
use App\Models\ControlArms;
use App\Models\Cooling;
use App\Models\Crank;
use App\Models\Differentials;
use App\Models\DownPipes;
use App\Models\EcuIgnitionCall;
use App\Models\EngineBrand;
use App\Models\EngineCc;
use App\Models\EngineYear;
use App\Models\Event;
use App\Models\Exhaust;
use App\Models\Exterior;
use App\Models\FilterIntake;
use App\Models\FlyWheel;
use App\Models\FuelBump;
use App\Models\FuelRegular;
use App\Models\Header;
use App\Models\HydraulicHandBrake;
use App\Models\IgnitionCall;
use App\Models\Injectors;
use App\Models\Interior;
use App\Models\JobTitle;

use App\Models\MotoTopSpeed;
use App\Models\Nationality;
use App\Models\Country;
use App\Models\City;
use App\Models\Lens;
use App\Models\LinkingWires;
use App\Models\Manifold;
use App\Models\MidPipes;
use App\Models\NaSuperChargoTurbo;
use App\Models\NoCylinder;
use App\Models\Nos;
use App\Models\Oil;
use App\Models\Participation;
use App\Models\Pistons;
use App\Models\RearSection;
use App\Models\Retainer;
use App\Models\RimBrand;
use App\Models\RimSize;
use App\Models\SparkPlugs;
use App\Models\SteeringAngel;
use App\Models\SteeringBox;
use App\Models\TierBrand;
use App\Models\Transmutation;
use App\Models\ValueSpring;
use App\Models\CarTorqueRpm;
use App\Models\CarDrivetrain;
use App\Models\CarEnginePlace;
use App\Models\CarTransmationGear;
use App\Models\CarWight;
use App\Models\CarBodyType;
use App\Models\VonHistory;
use App\Models\CarZeroHundredKmph;
use App\Models\CarMaxSpeed;
use App\Models\CarHorsePower;
use App\Models\CarHorsePowerRpm;
use App\Models\CarStock;
use App\Models\SuperKit;
use App\Models\TurboKit;
use App\Models\WestGate;
use App\Models\BlowOfValve;
use App\Models\BoostController;
use App\Models\ParticipationEvent;
use App\Models\CarSuperchargeOrTurbo; 
use Exception;
use Illuminate\Http\Request;
use App\Models\Moto;
use App\Models\MotoAirFilter;
use App\Models\MotoBlowOfValve;
use App\Models\MotoBoostController;
use App\Models\MotoBrakeLine;
use App\Models\MotoBrakeMasterCylinder;
use App\Models\MotoBrakePad;
use App\Models\MotoBrakeRotor;
use App\Models\MotoCaliper;
use App\Models\MotoCamShaft;
use App\Models\MotoClutch;
use App\Models\MotoConnectingRod;
use App\Models\MotoControl;
use App\Models\MotoCoolingSystem;
use App\Models\MotoCrankShaft;
use App\Models\MotoCrashBar;
use App\Models\MotoEcu;
use App\Models\MotoEngineBrand;
use App\Models\MotoEngineGuard;
use App\Models\MotoEngineModel;
use App\Models\MotoEngineYear;
use App\Models\MotoFinalDrive;
use App\Models\MotoFork;
use App\Models\MotoFuelinjector;
use App\Models\MotoFuelManagement;
use App\Models\MotoHeader;
use App\Models\MotoHyperCharge;
use App\Models\MotoIgnition;
use App\Models\MotoLoweringLink;
use App\Models\MotoManifold;
use App\Models\MotoNaSuperChrageTurbo;
use App\Models\MotoNos;
use App\Models\MotoPipe;
use App\Models\MotoPiston;
use App\Models\MotoPrimaryDrive;
use App\Models\MotoRimsBrand;
use App\Models\MotoRimsSize;
use App\Models\MotoSeat;
use App\Models\MotoShock;
use App\Models\MotoSilpone;
use App\Models\MotoSprocket;
use App\Models\MotoTiresBrand;
use App\Models\MotoTurboKit;
use App\Models\MotoValve;
use App\Models\MotoWestgate;


use App\Models\MotoCategory;
use App\Models\MotoDisplacement;
use App\Models\MotoEngineDetails;
use App\Models\MotoPower;
use App\Models\MotoPowerRpm;
use App\Models\MotoTorque;
use App\Models\MotoTorqueRpm;
use App\Models\MotoZeroOne;
use App\Models\MotoCompression;
use App\Models\MotoStroke;
use App\Models\MotoValvesPerCylinder;
use App\Models\MotoGearBox;
use App\Models\MotoTransmissionType;
use App\Models\MotoWeight;
use App\Models\MotoStock;


class CarController extends Controller
{


    public function get_car_makes()
    {
        
       $data = CarMake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_years(Request $request)
    {
        //dd($request->make_id);
        
      $car_years = CarStock::where('brand_id',$request->make_id)->pluck('year_id');
     
       $data = CarYear::orderBy('name','DESC')->whereIn('id',$car_years)->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_models(Request $request)
    {
       
       $car_years = CarStock::where('brand_id',$request->make_id)->where('year_id',$request->year_id)->pluck('model_id');
       $data = CarModel::whereIn('id',$car_years)->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_model_versions(Request $request)
    {
        
      $car_years = CarStock::where('brand_id',$request->make_id)->where('year_id',$request->year_id)->where('model_id',$request->model_id)->pluck('model_version_id');
         
       $data = CarModelVersion::whereIn('id',$car_years)->get();
       
       
       return $this->apiResponse(200 , null , $data);
    }

    public function get_manifolds()
    {
       $data = Manifold::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_mid_pipes()
    {
       $data = MidPipes::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_down_pipes()
    {
       $data = DownPipes::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rear_sections()
    {
       $data = RearSection::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_steering_angels()
    {
       $data = SteeringAngel::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_steering_boxes()
    {
       $data = SteeringBox::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_tier_brands()
    {
       $data = TierBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rim_brands()
    {
       $data = RimBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rim_sizes()
    {
       $data = RimSize::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_ignition_calls()
    {
       $data = IgnitionCall::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_spark_plugs()
    {
       $data = SparkPlugs::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_linking_wires()
    {
       $data = LinkingWires::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_ecu_ignition_calls()
    {
       $data = EcuIgnitionCall::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_coolings()
    {
       $data = Cooling::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_filter_intakes()
    {
       $data = FilterIntake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_interiors()
    {
       $data = Interior::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_oils()
    {
       $data = Oil::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_exteriors()
    {
       $data = Exterior::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_coil_overs()
    {
       $data = CoilOvers::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_brake_kits()
    {
       $data = BrakeKit::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_control_arms()
    {
       $data = ControlArms::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_hydraulic_hand_brakes()
    {
       $data = HydraulicHandBrake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_injectors()
    {
       $data = Injectors::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fuel_bumps()
    {
       $data = FuelBump::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fuel_regulars()
    {
       $data = FuelRegular::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_exhausts()
    {
       $data = Exhaust::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_headers()
    {
       $data = Header::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_brands()
    {
       $data = EngineBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_year()
    {
       $data = EngineYear::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_no_cylinders(Request $request)
    {
       $car_years = CarStock::where('brand_id',$request->make_id)->where('year_id',$request->year_id)->pluck('cylinder_id');
       $data = CarCylinder::whereIn('id',$car_years)->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_cc(Request $request)
    {
       $car_years = CarStock::where('brand_id',$request->make_id)->where('year_id',$request->year_id)->where('cylinder_id',$request->cylinder_id)->pluck('engine_cc_id');
       
       
        
       
       
       $data = CarEngineCc::whereIn('id',$car_years)->get();
       return $this->apiResponse(200 , null , $data);
    }
   
    public function get_no_clyinder_engine_cc(Request $request){
        
         $car_stock = CarStock::select('cylinder_id','engine_cc_id')->where('brand_id',$request->make_id)->where('year_id',$request->year_id)->where('model_id',$request->model_id)->where('model_version_id',$request->model_version_id)->first();
         $car_cylinder =  CarCylinder::select('id','name')->where('id',$car_stock->cylinder_id)->first();
         $car_engine_cc = CarEngineCC::select('id','name')->where('id',$car_stock->engine_cc_id)->first();
         
         $data['car_cylinder'] =  $car_cylinder;
         $data['car_engine_cc'] =  $car_engine_cc;
         
         return $this->apiResponse(200 , null , $data);
    }

    public function get_nos()
    {
       $data = Nos::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_na_super_chargo_turbos()
    {
       $data = NaSuperChargoTurbo::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_pistons()
    {
       $data = Pistons::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_connecting_rods()
    {
       $data = ConnectingRods::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_cranks()
    {
       $data = Crank::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_cams()
    {
       $data = Cam::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_value_springs()
    {
       $data = ValueSpring::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_retainers()
    {
       $data = Retainer::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_transmutations()
    {
       $data = Transmutation::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_differentials()
    {
       $data = Differentials::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_clutches()
    {
       $data = Clutch::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fly_wheels()
    {
       $data = FlyWheel::get();
       return $this->apiResponse(200 , null , $data);
    }


    
    
    /////
    
     public function get_turbo_kits()
    {
       $data = TurboKit::select('id','name')->where('name','!=','')->get();
       return $this->apiResponse(200 , null , $data);
    }

    
    public function get_super_charge_kits()
    {
       $data = SuperKit::select('id','name')->where('name','!=','')->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_blow_of_valves()
    {
       $data = BlowOfValve::select('id','name')->where('name','!=','')->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_wastgates()
    {
       $data = WestGate::select('id','name')->where('name','!=','')->get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_boost_controllers()
    {
       $data = BoostController::select('id','name')->where('name','!=','')->get();
       return $this->apiResponse(200 , null , $data);
    }
    




  public function update_car(Request $request)
    {
        
        
        $user = auth()->user();
        $car = Car::where('id',$request->car_id)->first();
          
          if($request->manifold_id)
          $car->manifold_id = $request->manifold_id;
          
          if($request->mid_pipe_id)
          $car->mid_pipe_id = $request->mid_pipe_id;
          
          if($request->down_pipe_id)
          $car->down_pipe_id = $request->down_pipe_id;
          
          if($request->rear_section_id)
          $car->rear_section_id = $request->rear_section_id;
          
          if($request->steering_angel_id)
          $car->steering_angel_id = $request->steering_angel_id;
          
          if($request->tier_brand_id)
          $car->steering_box_id = $request->tier_brand_id;
          
          if($request->tier_brand_id)
          $car->tier_brand_id = $request->tier_brand_id;
          
          if($request->ignition_call_id)
          $car->ignition_call_id = $request->ignition_call_id;
          
          if($request->spark_plug_id)
          $car->spark_plug_id = $request->spark_plug_id;
          
          if($request->linking_wire_id)
          $car->linking_wire_id = $request->linking_wire_id;
          
          if($request->ecu_ignition_call_id)
          $car->ecu_ignition_call_id = $request->ecu_ignition_call_id;
          
          if($request->filter_intake_id)
          $car->filter_intake_id = $request->filter_intake_id;
          
          if($request->interior_id)
          $car->interior_id = $request->interior_id;
          
          if($request->oil_id)
          $car->oil_id = $request->oil_id;
          
          if($request->brake_kit_id)
          $car->brake_kit_id = $request->brake_kit_id;
          
          if($request->control_arm_id)
          $car->control_arm_id = $request->control_arm_id;
          
          if($request->hydraulic_hand_brake_id)
          $car->hydraulic_hand_brake_id = $request->hydraulic_hand_brake_id;
          
          if($request->injector_id)
          $car->injector_id = $request->injector_id;
          
          if($request->fuel_bump_id)
          $car->fuel_bump_id = $request->fuel_bump_id;
          
          if($request->fuel_regular_id)
          $car->fuel_regular_id = $request->fuel_regular_id;
          
          if($request->exhaust_id)
          $car->exhaust_id = $request->exhaust_id;
          
          if($request->header_id)
          $car->header_id = $request->header_id;
          
          if($request->engine_brand_id)
          $car->engine_brand_id = $request->engine_brand_id;
          
          if($request->engine_year_id)
          $car->engine_year_id = $request->engine_year_id;
          
          if($request->no_cylinder_id)
          $car->no_cylinder_id = $request->no_cylinder_id;
          
          if($request->engine_cc_id)
          $car->engine_cc_id = $request->engine_cc_id;
          
          if($request->nos_id)
          $car->nos_id = $request->nos_id;
          
          if($request->na_super_chargo_turbo_id)
          $car->na_super_chargo_turbo_id = $request->na_super_chargo_turbo_id;
          
          if($request->piston_id)
          $car->piston_id = $request->piston_id;
          
          if($request->connecting_rod_id)
          $car->connecting_rod_id = $request->connecting_rod_id;
          
          if($request->crank_id)
          $car->crank_id = $request->crank_id;
          
          if($request->cam_id)
          $car->cam_id = $request->cam_id;
          
          if($request->value_spring_id)
          $car->value_spring_id = $request->value_spring_id;
          
          if($request->retainer_id)
          $car->retainer_id = $request->retainer_id;
          
          if($request->transmutation_id)
          $car->transmutation_id = $request->transmutation_id;
          
          if($request->differential_id)
          $car->differential_id = $request->differential_id;
          
          if($request->clutche_id)
          $car->clutche_id = $request->clutche_id;
          
          if($request->fly_wheel_id)
          $car->fly_wheel_id = $request->fly_wheel_id;
          
          if($request->car_brand_id)
          $car->car_brand_id = $request->car_brand_id;
          
          if($request->car_year)
          $car->car_year = $request->car_year;
          
          
          if($request->car_model_id)
          $car->car_model_id = $request->car_model_id;
          
          if($request->car_version_id)
          $car->car_version_id = $request->car_version_id;
          
          if($request->boost_controllers_id)
          $car->boost_controllers_id = $request->boost_controllers_id;
          
          if($request->blow_of_valve_id)
          $car->blow_of_valve_id = $request->blow_of_valve_id;
          
          if($request->turbo_kits_id)
          $car->turbo_kits_id = $request->turbo_kits_id;
          
          
          if($request->west_gate_id)
          $car->west_gate_id = $request->west_gate_id;
          
          if($request->modified_engine_cc)
          $car->modified_engine_cc = $request->modified_engine_cc;
          
          if($request->modified_max_speed)
          $car->modified_max_speed = $request->modified_max_speed;
          
          if($request->modified_torque)
          $car->modified_torque = $request->modified_torque;
          
          if($request->modified_zero_hundred)
          $car->modified_zero_hundred = $request->modified_zero_hundred;
          
          if($request->modified_hourse_power)
          $car->modified_hourse_power = $request->modified_hourse_power;
          
          if($request->stock)
          $car->stock = $request->stock;
          
          $car->data_cache = $request->data_cache;
          $car->engine_code = $request->engine_code;
          $car->stock = $request->stock;
          
          $car->user_id =  $user->id;
        

        if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $car->image = $image_name;
        }
        
    $von_text = $user->name." has now modified their car";
        
     VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $car->id , 'von_type' => 'update_car' ]);

        
        $car->save();
        
        
        return $this->apiResponse(200 , null , $car);
    }

    public function save_car(Request $request)
    {
        $user = auth()->user();
        
        if($request->stock == 0){
            
        $car = Car::create([
         'car_brand_id'=> $request->car_brand_id,
         'car_year'=> $request->car_year,
         'car_model_id'=> $request->car_model_id,
         'car_version_id'=> $request->car_version_id,
          'engine_brand_id'=> $request->car_brand_id,
         'engine_year_id'=> $request->car_year,
         'no_cylinder_id'=> $request->no_cylinder_id,
         'engine_cc_id'=> $request->engine_cc_id,
         'stock'=> $request->stock,
          'data_cache'=> $request->data_cache,
        ]);

        } else {
            
        $car = Car::create([
         'manifold_id' => $request->manifold_id,
         'mid_pipe_id'=> $request->mid_pipe_id,
         'down_pipe_id'=> $request->down_pipe_id,
         'rear_section_id'=> $request->rear_section_id,
         'steering_angel_id'=> $request->steering_angel_id,
         'steering_box_id'=> $request->steering_box_id,
         'tier_brand_id'=> $request->tier_brand_id,
         'rim_brand_id'=> $request->rim_brand_id,
         'rim_size_id'=> $request->rim_size_id,
         'ignition_call_id'=> $request->ignition_call_id,
         'spark_plug_id'=> $request->spark_plug_id,
         'linking_wire_id'=> $request->linking_wire_id,
         'ecu_ignition_call_id'=> $request->ecu_ignition_call_id,
         'cooling_id'=> $request->cooling_id,
         'filter_intake_id'=> $request->filter_intake_id,
         'interior_id'=> $request->interior_id,
         'oil_id'=> $request->oil_id,
         'exterior_id'=> $request->exterior_id,
         'coil_over_id' => $request->coil_over_id,
         'brake_kit_id'=> $request->brake_kit_id,
         'control_arm_id'=> $request->control_arm_id,
         'hydraulic_hand_brake_id'=> $request->hydraulic_hand_brake_id,
         'injector_id'=> $request->injector_id,
         'fuel_bump_id'=> $request->fuel_bump_id,
         'fuel_regular_id'=> $request->fuel_regular_id,
         'exhaust_id'=> $request->exhaust_id,
         'header_id'=> $request->header_id,
         'engine_brand_id'=> $request->engine_brand_id,
         'engine_year_id'=> $request->engine_year_id,
         'no_cylinder_id'=> $request->no_cylinder_id,
         'engine_cc_id'=> $request->engine_cc_id,
         'nos_id'=> $request->nos_id,
         'na_super_chargo_turbo_id'=> $request->na_super_chargo_turbo_id,
         'piston_id'=> $request->piston_id,
         'connecting_rod_id'=> $request->connecting_rod_id,
         'crank_id'=> $request->crank_id,
         'cam_id'=> $request->cam_id,
         'value_spring_id'=> $request->value_spring_id,
         'retainer_id'=> $request->retainer_id,
         'transmutation_id'=> $request->transmutation_id,
         'differential_id'=> $request->differential_id,
         'clutche_id'=> $request->clutche_id,
         'fly_wheel_id'=> $request->fly_wheel_id,
         'car_brand_id'=> $request->car_brand_id,
         'car_year'=> $request->car_year,
         'car_model_id'=> $request->car_model_id,
         'car_version_id'=> $request->car_version_id,
         'boost_controllers_id'=> $request->boost_controllers_id,
         'blow_of_valve_id'=> $request->blow_of_valve_id,
         'turbo_kits_id'=> $request->turbo_kits_id,
         'west_gate_id'=> $request->west_gate_id,
         'modified_engine_cc'=> $request->modified_engine_cc,
         'modified_max_speed'=> $request->modified_max_speed,
         'modified_torque'=> $request->modified_torque,
         'modified_zero_hundred'=> $request->modified_zero_hundred,
         'modified_hourse_power'=> $request->modified_hourse_power,
         
         
         
         
         'stock'=> $request->stock,
         'data_cache'=> $request->data_cache,
         'status'=> 1,
         'engine_code'=> $request->engine_code,


          ]);
        }
        
        
     $von_text = $user->name." has now added their stock car";
     
     
     if($request->stock==1){
        $von_text =$user->name." has now added their stock car";
     }
          
       VonHistory::create(['user_id' => $user->id , 'text' =>$von_text , 'von_id' => $car->id , 'von_type' => 'create_car' ]);
          
        $car->user_id =  $user->id;
        $car->save();

        if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $car->image = $image_name;
        $car->save();
        }
        return $this->apiResponse(200 , null , $car);
    }







    public function get_cars(Request $request)
    {
       $cars = Car::select('id','image','car_brand_id','car_year','car_model_id','car_version_id','modified_engine_cc','modified_max_speed','modified_torque','modified_zero_hundred','modified_hourse_power')->where('user_id',$request->user_id)->get();

       foreach($cars as $car){
           
            // $car->car_brand = CarBrand::select('id','name')->where('id',$car->car_brand_id)->first();
            // $car->car_model = CarModel::select('id','name')->where('id',$car->car_model_id)->first();
            // $car->car_version = CarVersion::select('id','name')->where('id',$car->car_version_id)->first();
            
          
            $car->image = asset('images/').'/'.$car->image  ;
            $car_stock = CarStock::where('brand_id',$car->car_brand_id)->where('year_id',$car->car_year)->where('model_id',$car->car_model_id)
            ->where('model_version_id',$car->car_version_id)
            ->first();
            
            
            
               //  dd($car_stock->model_plat_form_year_id);
        
            
                   $car_make =  CarMake::select('name')->where('id',$car_stock->brand_id)->first()->name;
                   $car_year = CarYear::select('name')->where('id',$car_stock->year_id)->first()->name;
                   $car_model =  CarModel::select('name')->where('id',$car_stock->model_id)->first()->name;
                   $car_cylinder =  CarCylinder::select('name')->where('id',$car_stock->cylinder_id)->first()->name;
                   $car_engine_cc = CarEngineCC::select('name')->where('id',$car_stock->engine_cc_id)->first()->name;
                   $car_model_version = CarModelVersion::select('name')->where('id',$car_stock->model_version_id)->first()->name;
                   $car_plat_form_year = CarPlatFormYear::select('name')->where('id',$car_stock->model_plat_form_year_id)->first()->name;
                   $car_horse_power = CarHorsePower::select('name')->where('id',$car_stock->horse_power_id)->first()->name;
                   $car_horse_power_rpm = CarHorsePowerRpm::select('name')->where('id',$car_stock->horse_power_rpm_id)->first()->name;
                   $car_torque = CarTorque::select('name')->where('id',$car_stock->torque_id)->first()->name;
                   $car_torque_rpm =  CarTorqueRpm::select('name')->where('id',$car_stock->torque_rpm_id)->first()->name;
                   $super_charge_turbo = CarSuperchargeOrTurbo::select('name')->where('id',$car_stock->turbo_id)->first()->name;
                   $car_drive_train = CarDrivetrain::select('name')->where('id',$car_stock->drive_train_id)->first()->name;
                   $car_engine_place = CarEnginePlace::select('name')->where('id',$car_stock->engine_place_id)->first()->name;
                   $car_transmation =  CarTransmationGear::select('name')->where('id',$car_stock->transmation_gear_id)->first()->name;
                   $car_wight = CarWight::select('name')->where('id',$car_stock->weight_id)->first()->name;
                   $car_body = CarBodyType::select('name')->where('id',$car_stock->body_type_id)->first()->name;
                   $car_zero_hundred = CarZeroHundredKmph::select('name')->where('id',$car_stock->zero_hundred_id)->first()->name;
                   $car_max_speed = CarMaxSpeed::select('name')->where('id',$car_stock->max_speed_id)->first()->name;
                   
                   if($car->modified_engine_cc){
                       $car_engine_cc = $car->modified_engine_cc;
                   }
                   
                   if($car->modified_hourse_power){
                       $car_horse_power = $car->modified_hourse_power;
                   }
                   
                   if($car->modified_max_speed){
                       $car_max_speed = $car->modified_max_speed;
                   }
                   
                   
                   if($car->modified_torque){
                       $car_torque = $car->modified_torque;
                   }
                   
                   if($car->modified_zero_hundred){
                       $car_zero_hundred = $car->modified_zero_hundred;
                   }
                   
                
                if(!$car_wight)$car_wight=0;
            $car->snario = $car_make." ,".$car_model." , ".$car_plat_form_year." , ".$car_model_version." , ".$car_cylinder.",".$car_engine_cc." CC , ".$car_horse_power." HP , ".$car_horse_power_rpm." RPM , ".$car_torque." N/M , ".$car_torque_rpm." RPM , ".$car_zero_hundred." Seconds , ".$car_max_speed." KM/H , ".$car_engine_place." Engine Place , Gear Box : ".$car_transmation." , ".$car_drive_train." Drive Train , ".$car_body." , ".$car_wight." KG";
            
            
            
            
            
       }
       
       

       return $this->apiResponse(200 , null , $cars);
    }


    public function get_car_details(Request $request)
    {
            $car = Car::where('id',$request->car_id)->first();
            $car->image = asset('images/').'/'.$car->image  ;
            $car->car_brand = CarBrand::select('id','name')->where('id',$car->car_brand_id)->first();
            $car->car_model = CarModel::select('id','name')->where('id',$car->car_model_id)->first();
            $car->car_version = CarVersion::select('id','name')->where('id',$car->car_version_id)->first();
       return $this->apiResponse(200 , null , $car);
    }


    public function get_participations(Request $request)
    {
        
     // dd($request->user_id);
        $user_id=$request->user_id;
        $participation_id = 0;
        $old_participation = Participation::where('user_id',$request->user_id)->first();
        
        
        if(!$old_participation){
         $participations = Participation::create([
       'year' => 0,
       'padiums' => 0,
       'participations'  => 0,
       'champions'  =>  0,
       'user_id'  => $user_id,
        ]);
 
        
        }else {
            
               
        
       $all_events = Event::select('id','name','image','date','user_id')->get();

       $participation = Participation::select('id','year','padiums','participations','champions','user_id')->where('user_id',$request->user_id)->first();
       
       $events =  ParticipationEvent::select('event_id as id','rank')->where('participation_id',$participation->id)->get();

       foreach($events as $event){
          $event_details =   Event::select('id','name','image','date','user_id')->where('id',$event->id)->first();
          if($event_details){
          $event->name = $event_details->name;
          $event->image = asset('images/').'/'.$event_details->image;
           $event->user_id = $event_details->user_id;
          }
       }
    }
     
       $participation->events = $events;
       
       $participation->all_events=$all_events;
  
       
       return $this->apiResponse(200 , null , $participation);
    }

    public function set_participations(Request $request)
    {
        $user_id =  auth()->user()->id;
             $user = auth()->user();
        $participation_id = 0;
        $old_participation = Participation::where('user_id',$user_id)->first();
      
        
        if($old_participation){
            
        $old_participation->year = $request->year;
        $old_participation->participations = $request->participations;
        $old_participation->padiums = $request->padiums;
        $old_participation->champions = $request->champions;
        $old_participation->save();
        
        $participation_id = $old_participation->id;
        
        
                
            $von_text = $user->name." updated their participation";
        
     VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $participation_id , 'von_type' => 'update_car' ]); 
     
        
        }else {
            
            
            
            
       $participations = Participation::create([
       'year' => $request->year,
       'padiums' => $request->padiums,
       'participations'  => $request->participations,
       'champions'  =>  $request->champions,
       'rank'  => $request->rank,
       'event_id'  => $request->event_id,
       'user_id'  => $user_id,
        ]);
        
        $participation_id = $participations->id;
        
        
               
            $von_text = $user->name." created their participation";
        
     VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $participation_id , 'von_type' => 'update_car' ]);  
        
        
        }
         
        
          $participations = Participation::where('id',$participation_id)->first();
        
        ParticipationEvent::where('participation_id',$participation_id)->delete();
        
        $events = $request->events;
        $ranks = $request->ranks;
        
        if($events){
       
          for($i=0; $i<count($events); $i++){
           ParticipationEvent::create(['participation_id' => $participation_id,
           'event_id' => $events[$i],
           'rank' =>  $ranks[$i]]);
                
          }
        
        }
        

       return $this->apiResponse(200 , null , $participations);
    }


    public function remove_participations(Request $request)
    {
        $user = auth()->user();
        $participation = Participation::where('id',$request->participation_id)->first();

       if($participation->user_id == $user->id){
        $participation->delete();
        return $this->apiResponse(200 , null , $participation);
       } else {
        return $this->apiResponse(401 , 'you are not authorized' , $participation);
       }
    }



    public function remove_car(Request $request)
    {
        $user = auth()->user();
        $car = Car::where('id',$request->car_id)->first();

       if($car->user_id == $user->id){
        $car->delete();
        return $this->apiResponse(200 , null ,null);
       } else {
        return $this->apiResponse(401 , 'you are not authorized' , null);
       }

    }

    public function addData()
    {
        
        
        
        $jsonString = '{
  "countries": [
    {
      "country": "Afghanistan",
      "states": ["Badakhshan", "Badghis", "Baghlan", "Balkh", "Bamian", "Daykondi", "Farah", "Faryab", "Ghazni", "Ghowr", "Helmand", "Herat", "Jowzjan", "Kabul", "Kandahar", "Kapisa", "Khost", "Konar", "Kondoz", "Laghman", "Lowgar", "Nangarhar", "Nimruz", "Nurestan", "Oruzgan", "Paktia", "Paktika", "Panjshir", "Parvan", "Samangan", "Sar-e Pol", "Takhar", "Vardak", "Zabol"]
    },
    {
      "country": "Albania",
      "states": ["Berat", "Dibres", "Durres", "Elbasan", "Fier", "Gjirokastre", "Korce", "Kukes", "Lezhe", "Shkoder", "Tirane", "Vlore"]
    },
    {
      "country": "Algeria",
      "states": ["Adrar", "Ain Defla", "Ain Temouchent", "Alger", "Annaba", "Batna", "Bechar", "Bejaia", "Biskra", "Blida", "Bordj Bou Arreridj", "Bouira", "Boumerdes", "Chlef", "Constantine", "Djelfa", "El Bayadh", "El Oued", "El Tarf", "Ghardaia", "Guelma", "Illizi", "Jijel", "Khenchela", "Laghouat", "Muaskar", "Medea", "Mila", "Mostaganem", "MSila", "Naama", "Oran", "Ouargla", "Oum el Bouaghi", "Relizane", "Saida", "Setif", "Sidi Bel Abbes", "Skikda", "Souk Ahras", "Tamanghasset", "Tebessa", "Tiaret", "Tindouf", "Tipaza", "Tissemsilt", "Tizi Ouzou", "Tlemcen"]
    },
    {
      "country": "Andorra",
      "states": ["Andorra la Vella", "Canillo", "Encamp", "Escaldes-Engordany", "La Massana", "Ordino", "Sant Julia de Loria"]
    },
    {
      "country": "Angola",
      "states": ["Bengo", "Benguela", "Bie", "Cabinda", "Cuando Cubango", "Cuanza Norte", "Cuanza Sul", "Cunene", "Huambo", "Huila", "Luanda", "Lunda Norte", "Lunda Sul", "Malanje", "Moxico", "Namibe", "Uige", "Zaire"]
    },
    {
      "country": "Antarctica",
      "states": []
    },
    {
      "country": "Antigua and Barbuda",
      "states": ["Barbuda", "Redonda", "Saint George", "Saint John", "Saint Mary", "Saint Paul", "Saint Peter", "Saint Philip"]
    },
    {
      "country": "Argentina",
      "states": ["Buenos Aires", "Buenos Aires Capital", "Catamarca", "Chaco", "Chubut", "Cordoba", "Corrientes", "Entre Rios", "Formosa", "Jujuy", "La Pampa", "La Rioja", "Mendoza", "Misiones", "Neuquen", "Rio Negro", "Salta", "San Juan", "San Luis", "Santa Cruz", "Santa Fe", "Santiago del Estero", "Tierra del Fuego", "Tucuman"]
    },
    {
      "country": "Armenia",
      "states": ["Aragatsotn", "Ararat", "Armavir", "Gegharkunik", "Kotayk", "Lorri", "Shirak", "Syunik", "Tavush", "Vayots Dzor", "Yerevan"]
    },
    {
      "country": "Australia",
      "states": []
    },
    {
      "country": "Austria",
      "states": ["Burgenland", "Kaernten", "Niederoesterreich", "Oberoesterreich", "Salzburg", "Steiermark", "Tirol", "Vorarlberg", "Wien"]
    },
    {
      "country": "Azerbaijan",
      "states": ["Abseron Rayonu", "Agcabadi Rayonu", "Agdam Rayonu", "Agdas Rayonu", "Agstafa Rayonu", "Agsu Rayonu", "Astara Rayonu", "Balakan Rayonu", "Barda Rayonu", "Beylaqan Rayonu", "Bilasuvar Rayonu", "Cabrayil Rayonu", "Calilabad Rayonu", "Daskasan Rayonu", "Davaci Rayonu", "Fuzuli Rayonu", "Gadabay Rayonu", "Goranboy Rayonu", "Goycay Rayonu", "Haciqabul Rayonu", "Imisli Rayonu", "Ismayilli Rayonu", "Kalbacar Rayonu", "Kurdamir Rayonu", "Lacin Rayonu", "Lankaran Rayonu", "Lerik Rayonu", "Masalli Rayonu", "Neftcala Rayonu", "Oguz Rayonu", "Qabala Rayonu", "Qax Rayonu", "Qazax Rayonu", "Qobustan Rayonu", "Quba Rayonu", "Qubadli Rayonu", "Qusar Rayonu", "Saatli Rayonu", "Sabirabad Rayonu", "Saki Rayonu", "Salyan Rayonu", "Samaxi Rayonu", "Samkir Rayonu", "Samux Rayonu", "Siyazan Rayonu", "Susa Rayonu", "Tartar Rayonu", "Tovuz Rayonu", "Ucar Rayonu", "Xacmaz Rayonu", "Xanlar Rayonu", "Xizi Rayonu", "Xocali Rayonu", "Xocavand Rayonu", "Yardimli Rayonu", "Yevlax Rayonu", "Zangilan Rayonu", "Zaqatala Rayonu", "Zardab Rayonu", "Ali Bayramli Sahari", "Baki Sahari", "Ganca Sahari", "Lankaran Sahari", "Mingacevir Sahari", "Naftalan Sahari", "Saki Sahari", "Sumqayit Sahari", "Susa Sahari", "Xankandi Sahari", "Yevlax Sahari", "Naxcivan Muxtar"]
    },
    {
      "country": "Bahamas",
      "states": ["Acklins and Crooked Islands", "Bimini", "Cat Island", "Exuma", "Freeport", "Fresh Creek", "Governors Harbour", "Green Turtle Cay", "Harbour Island", "High Rock", "Inagua", "Kemps Bay", "Long Island", "Marsh Harbour", "Mayaguana", "New Providence", "Nichollstown and Berry Islands", "Ragged Island", "Rock Sound", "Sandy Point", "San Salvador and Rum Cay"]
    },
    {
      "country": "Bahrain",
      "states": ["Al Hadd", "Al Manamah", "Al Mintaqah al Gharbiyah", "Al Mintaqah al Wusta", "Al Mintaqah ash Shamaliyah", "Al Muharraq", "Ar Rifa wa al Mintaqah al Janubiyah", "Jidd Hafs", "Madinat Hamad", "Madinat Isa", "Juzur Hawar", "Sitrah"]
    },
    {
      "country": "Bangladesh",
      "states": ["Barisal", "Chittagong", "Dhaka", "Khulna", "Rajshahi", "Sylhet"]
    },
    {
      "country": "Barbados",
      "states": ["Christ Church", "Saint Andrew", "Saint George", "Saint James", "Saint John", "Saint Joseph", "Saint Lucy", "Saint Michael", "Saint Peter", "Saint Philip", "Saint Thomas"]
    },
    {
      "country": "Belarus",
      "states": ["Brest", "Homyel", "Horad Minsk", "Hrodna", "Mahilyow", "Minsk", "Vitsyebsk"]
    },
    {
      "country": "Belgium",
      "states": ["Antwerpen", "Brabant Wallon", "Brussels", "Flanders", "Hainaut", "Liege", "Limburg", "Luxembourg", "Namur", "Oost-Vlaanderen", "Vlaams-Brabant", "Wallonia", "West-Vlaanderen"]
    },
    {
      "country": "Belize",
      "states": ["Belize", "Cayo", "Corozal", "Orange Walk", "Stann Creek", "Toledo"]
    },
    {
      "country": "Benin",
      "states": ["Alibori", "Atakora", "Atlantique", "Borgou", "Collines", "Donga", "Kouffo", "Littoral", "Mono", "Oueme", "Plateau", "Zou"]
    },
    {
      "country": "Bermuda",
      "states": ["Devonshire", "Hamilton", "Hamilton", "Paget", "Pembroke", "Saint George", "Saint Georges", "Sandys", "Smiths", "Southampton", "Warwick"]
    },
    {
      "country": "Bhutan",
      "states": ["Bumthang", "Chukha", "Dagana", "Gasa", "Haa", "Lhuntse", "Mongar", "Paro", "Pemagatshel", "Punakha", "Samdrup Jongkhar", "Samtse", "Sarpang", "Thimphu", "Trashigang", "Trashiyangste", "Trongsa", "Tsirang", "Wangdue Phodrang", "Zhemgang"]
    },
    {
      "country": "Bolivia",
      "states": ["Chuquisaca", "Cochabamba", "Beni", "La Paz", "Oruro", "Pando", "Potosi", "Santa Cruz", "Tarija"]
    },
    {
      "country": "Bosnia and Herzegovina",
      "states": ["Una-Sana [Federation]", "Posavina [Federation]", "Tuzla [Federation]", "Zenica-Doboj [Federation]", "Bosnian Podrinje [Federation]", "Central Bosnia [Federation]", "Herzegovina-Neretva [Federation]", "West Herzegovina [Federation]", "Sarajevo [Federation]", " West Bosnia [Federation]", "Banja Luka [RS]", "Bijeljina [RS]", "Doboj [RS]", "Fo?a [RS]", "Sarajevo-Romanija [RS]", "Trebinje [RS]", "Vlasenica [RS]"]
    },
    {
      "country": "Botswana",
      "states": ["Central", "Ghanzi", "Kgalagadi", "Kgatleng", "Kweneng", "North East", "North West", "South East", "Southern"]
    },
    {
      "country": "Brazil",
      "states": ["Acre", "Alagoas", "Amapa", "Amazonas", "Bahia", "Ceara", "Distrito Federal", "Espirito Santo", "Goias", "Maranhao", "Mato Grosso", "Mato Grosso do Sul", "Minas Gerais", "Para", "Paraiba", "Parana", "Pernambuco", "Piaui", "Rio de Janeiro", "Rio Grande do Norte", "Rio Grande do Sul", "Rondonia", "Roraima", "Santa Catarina", "Sao Paulo", "Sergipe", "Tocantins"]
    },
    {
      "country": "Brunei",
      "states": ["Belait", "Brunei and Muara", "Temburong", "Tutong"]
    },
    {
      "country": "Bulgaria",
      "states": ["Blagoevgrad", "Burgas", "Dobrich", "Gabrovo", "Khaskovo", "Kurdzhali", "Kyustendil", "Lovech", "Montana", "Pazardzhik", "Pernik", "Pleven", "Plovdiv", "Razgrad", "Ruse", "Shumen", "Silistra", "Sliven", "Smolyan", "Sofiya", "Sofiya-Grad", "Stara Zagora", "Turgovishte", "Varna", "Veliko Turnovo", "Vidin", "Vratsa", "Yambol"]
    },
    {
      "country": "Burkina Faso",
      "states": ["Bale", "Bam", "Banwa", "Bazega", "Bougouriba", "Boulgou", "Boulkiemde", "Comoe", "Ganzourgou", "Gnagna", "Gourma", "Houet", "Ioba", "Kadiogo", "Kenedougou", "Komondjari", "Kompienga", "Kossi", "Koulpelogo", "Kouritenga", "Kourweogo", "Leraba", "Loroum", "Mouhoun", "Namentenga", "Nahouri", "Nayala", "Noumbiel", "Oubritenga", "Oudalan", "Passore", "Poni", "Sanguie", "Sanmatenga", "Seno", "Sissili", "Soum", "Sourou", "Tapoa", "Tuy", "Yagha", "Yatenga", "Ziro", "Zondoma", "Zoundweogo"]
    },
    {
      "country": "Burma",
      "states": ["Ayeyarwady", "Bago", "Magway", "Mandalay", "Sagaing", "Tanintharyi", "Yangon", "Chin State", "Kachin State", "Kayin State", "Kayah State", "Mon State", "Rakhine State", "Shan State"]
    },
    {
      "country": "Burundi",
      "states": ["Bubanza", "Bujumbura Mairie", "Bujumbura Rural", "Bururi", "Cankuzo", "Cibitoke", "Gitega", "Karuzi", "Kayanza", "Kirundo", "Makamba", "Muramvya", "Muyinga", "Mwaro", "Ngozi", "Rutana", "Ruyigi"]
    },
    {
      "country": "Cambodia",
      "states": ["Banteay Mean Chey", "Batdambang", "Kampong Cham", "Kampong Chhnang", "Kampong Spoe", "Kampong Thum", "Kampot", "Kandal", "Koh Kong", "Kracheh", "Mondol Kiri", "Otdar Mean Chey", "Pouthisat", "Preah Vihear", "Prey Veng", "Rotanakir", "Siem Reab", "Stoeng Treng", "Svay Rieng", "Takao", "Keb", "Pailin", "Phnom Penh", "Preah Seihanu"]
    },
    {
      "country": "Cameroon",
      "states": ["Adamaoua", "Centre", "Est", "Extreme-Nord", "Littoral", "Nord", "Nord-Ouest", "Ouest", "Sud", "Sud-Ouest"]
    },
    {
      "country": "Canada",
      "states": ["Alberta", "British Columbia", "Manitoba", "New Brunswick", "Newfoundland and Labrador", "Northwest Territories", "Nova Scotia", "Nunavut", "Ontario", "Prince Edward Island", "Quebec", "Saskatchewan", "Yukon Territory"]
    },
    {
      "country": "Cape Verde",
      "states": []
    },
    {
      "country": "Central African Republic",
      "states": ["Bamingui-Bangoran", "Bangui", "Basse-Kotto", "Haute-Kotto", "Haut-Mbomou", "Kemo", "Lobaye", "Mambere-Kadei", "Mbomou", "Nana-Grebizi", "Nana-Mambere", "Ombella-Mpoko", "Ouaka", "Ouham", "Ouham-Pende", "Sangha-Mbaere", "Vakaga"]
    },
    {
      "country": "Chad",
      "states": ["Batha", "Biltine", "Borkou-Ennedi-Tibesti", "Chari-Baguirmi", "Guéra", "Kanem", "Lac", "Logone Occidental", "Logone Oriental", "Mayo-Kebbi", "Moyen-Chari", "Ouaddaï", "Salamat", "Tandjile"]
    },
    {
      "country": "Chile",
      "states": ["Aysen", "Antofagasta", "Araucania", "Atacama", "Bio-Bio", "Coquimbo", "OHiggins", "Los Lagos", "Magallanes y la Antartica Chilena", "Maule", "Santiago Region Metropolitana", "Tarapaca", "Valparaiso"]
    },
    {
      "country": "China",
      "states": ["Anhui", "Fujian", "Gansu", "Guangdong", "Guizhou", "Hainan", "Hebei", "Heilongjiang", "Henan", "Hubei", "Hunan", "Jiangsu", "Jiangxi", "Jilin", "Liaoning", "Qinghai", "Shaanxi", "Shandong", "Shanxi", "Sichuan", "Yunnan", "Zhejiang", "Guangxi", "Nei Mongol", "Ningxia", "Xinjiang", "Xizang (Tibet)", "Beijing", "Chongqing", "Shanghai", "Tianjin"]
    },
    {
      "country": "Colombia",
      "states": ["Amazonas", "Antioquia", "Arauca", "Atlantico", "Bogota District Capital", "Bolivar", "Boyaca", "Caldas", "Caqueta", "Casanare", "Cauca", "Cesar", "Choco", "Cordoba", "Cundinamarca", "Guainia", "Guaviare", "Huila", "La Guajira", "Magdalena", "Meta", "Narino", "Norte de Santander", "Putumayo", "Quindio", "Risaralda", "San Andres & Providencia", "Santander", "Sucre", "Tolima", "Valle del Cauca", "Vaupes", "Vichada"]
    },
    {
      "country": "Comoros",
      "states": ["Grande Comore (Njazidja)", "Anjouan (Nzwani)", "Moheli (Mwali)"]
    },
    {
      "country": "Congo, Democratic Republic",
      "states": ["Bandundu", "Bas-Congo", "Equateur", "Kasai-Occidental", "Kasai-Oriental", "Katanga", "Kinshasa", "Maniema", "Nord-Kivu", "Orientale", "Sud-Kivu"]
    },
    {
      "country": "Congo, Republic of the",
      "states": ["Bouenza", "Brazzaville", "Cuvette", "Cuvette-Ouest", "Kouilou", "Lekoumou", "Likouala", "Niari", "Plateaux", "Pool", "Sangha"]
    },
    {
      "country": "Costa Rica",
      "states": ["Alajuela", "Cartago", "Guanacaste", "Heredia", "Limon", "Puntarenas", "San Jose"]
    },
    {
      "country": "Cote dIvoire",
      "states": []
    },
    {
      "country": "Croatia",
      "states": ["Bjelovarsko-Bilogorska", "Brodsko-Posavska", "Dubrovacko-Neretvanska", "Istarska", "Karlovacka", "Koprivnicko-Krizevacka", "Krapinsko-Zagorska", "Licko-Senjska", "Medimurska", "Osjecko-Baranjska", "Pozesko-Slavonska", "Primorsko-Goranska", "Sibensko-Kninska", "Sisacko-Moslavacka", "Splitsko-Dalmatinska", "Varazdinska", "Viroviticko-Podravska", "Vukovarsko-Srijemska", "Zadarska", "Zagreb", "Zagrebacka"]
    },
    {
      "country": "Cuba",
      "states": ["Camaguey", "Ciego de Avila", "Cienfuegos", "Ciudad de La Habana", "Granma", "Guantanamo", "Holguin", "Isla de la Juventud", "La Habana", "Las Tunas", "Matanzas", "Pinar del Rio", "Sancti Spiritus", "Santiago de Cuba", "Villa Clara"]
    },
    {
      "country": "Cyprus",
      "states": ["Famagusta", "Kyrenia", "Larnaca", "Limassol", "Nicosia", "Paphos"]
    },
    {
      "country": "Czech Republic",
      "states": ["Jihocesky Kraj", "Jihomoravsky Kraj", "Karlovarsky Kraj", "Kralovehradecky Kraj", "Liberecky Kraj", "Moravskoslezsky Kraj", "Olomoucky Kraj", "Pardubicky Kraj", "Plzensky Kraj", "Praha", "Stredocesky Kraj", "Ustecky Kraj", "Vysocina", "Zlinsky Kraj"]
    },
    {
      "country": "Denmark",
      "states": ["Arhus", "Bornholm", "Frederiksberg", "Frederiksborg", "Fyn", "Kobenhavn", "Kobenhavns", "Nordjylland", "Ribe", "Ringkobing", "Roskilde", "Sonderjylland", "Storstrom", "Vejle", "Vestsjalland", "Viborg"]
    },
    {
      "country": "Djibouti",
      "states": ["Ali Sabih", "Dikhil", "Djibouti", "Obock", "Tadjoura"]
    },
    {
      "country": "Dominica",
      "states": ["Saint Andrew", "Saint David", "Saint George", "Saint John", "Saint Joseph", "Saint Luke", "Saint Mark", "Saint Patrick", "Saint Paul", "Saint Peter"]
    },
    {
      "country": "Dominican Republic",
      "states": ["Azua", "Baoruco", "Barahona", "Dajabon", "Distrito Nacional", "Duarte", "Elias Pina", "El Seibo", "Espaillat", "Hato Mayor", "Independencia", "La Altagracia", "La Romana", "La Vega", "Maria Trinidad Sanchez", "Monsenor Nouel", "Monte Cristi", "Monte Plata", "Pedernales", "Peravia", "Puerto Plata", "Salcedo", "Samana", "Sanchez Ramirez", "San Cristobal", "San Jose de Ocoa", "San Juan", "San Pedro de Macoris", "Santiago", "Santiago Rodriguez", "Santo Domingo", "Valverde"]
    },
    {
      "country": "East Timor",
      "states": ["Aileu", "Ainaro", "Baucau", "Bobonaro", "Cova-Lima", "Dili", "Ermera", "Lautem", "Liquica", "Manatuto", "Manufahi", "Oecussi", "Viqueque"]
    },
    {
      "country": "Ecuador",
      "states": ["Azuay", "Bolivar", "Canar", "Carchi", "Chimborazo", "Cotopaxi", "El Oro", "Esmeraldas", "Galapagos", "Guayas", "Imbabura", "Loja", "Los Rios", "Manabi", "Morona-Santiago", "Napo", "Orellana", "Pastaza", "Pichincha", "Sucumbios", "Tungurahua", "Zamora-Chinchipe"]
    },
    {
      "country": "Egypt",
      "states": ["Ad Daqahliyah", "Al Bahr al Ahmar", "Al Buhayrah", "Al Fayyum", "Al Gharbiyah", "Al Iskandariyah", "Al Ismailiyah", "Al Jizah", "Al Minufiyah", "Al Minya", "Al Qahirah", "Al Qalyubiyah", "Al Wadi al Jadid", "Ash Sharqiyah", "As Suways", "Aswan", "Asyut", "Bani Suwayf", "Bur Said", "Dumyat", "Janub Sina", "Kafr ash Shaykh", "Matruh", "Qina", "Shamal Sina", "Suhaj"]
    },
    {
      "country": "El Salvador",
      "states": ["Ahuachapan", "Cabanas", "Chalatenango", "Cuscatlan", "La Libertad", "La Paz", "La Union", "Morazan", "San Miguel", "San Salvador", "Santa Ana", "San Vicente", "Sonsonate", "Usulutan"]
    },
    {
      "country": "Equatorial Guinea",
      "states": ["Annobon", "Bioko Norte", "Bioko Sur", "Centro Sur", "Kie-Ntem", "Litoral", "Wele-Nzas"]
    },
    {
      "country": "Eritrea",
      "states": ["Anseba", "Debub", "Debubawi Keyih Bahri", "Gash Barka", "Maakel", "Semenawi Keyih Bahri"]
    },
    {
      "country": "Estonia",
      "states": ["Harjumaa (Tallinn)", "Hiiumaa (Kardla)", "Ida-Virumaa (Johvi)", "Jarvamaa (Paide)", "Jogevamaa (Jogeva)", "Laanemaa (Haapsalu)", "Laane-Virumaa (Rakvere)", "Parnumaa (Parnu)", "Polvamaa (Polva)", "Raplamaa (Rapla)", "Saaremaa (Kuressaare)", "Tartumaa (Tartu)", "Valgamaa (Valga)", "Viljandimaa (Viljandi)", "Vorumaa (Voru)"]
    },
    {
      "country": "Ethiopia",
      "states": ["Addis Ababa", "Afar", "Amhara", "Binshangul Gumuz", "Dire Dawa", "Gambela Hizboch", "Harari", "Oromia", "Somali", "Tigray", "Southern Nations, Nationalities, and Peoples Region"]
    },
    {
      "country": "Fiji",
      "states": ["Central (Suva)", "Eastern (Levuka)", "Northern (Labasa)", "Rotuma", "Western (Lautoka)"]
    },
    {
      "country": "Finland",
      "states": ["Aland", "Etela-Suomen Laani", "Ita-Suomen Laani", "Lansi-Suomen Laani", "Lappi", "Oulun Laani"]
    },
    {
      "country": "France",
      "states": ["Alsace", "Aquitaine", "Auvergne", "Basse-Normandie", "Bourgogne", "Bretagne", "Centre", "Champagne-Ardenne", "Corse", "Franche-Comte", "Haute-Normandie", "Ile-de-France", "Languedoc-Roussillon", "Limousin", "Lorraine", "Midi-Pyrenees", "Nord-Pas-de-Calais", "Pays de la Loire", "Picardie", "Poitou-Charentes", "Provence-Alpes-Cote dAzur", "Rhone-Alpes"]
    },
    {
      "country": "Gabon",
      "states": ["Estuaire", "Haut-Ogooue", "Moyen-Ogooue", "Ngounie", "Nyanga", "Ogooue-Ivindo", "Ogooue-Lolo", "Ogooue-Maritime", "Woleu-Ntem"]
    },
    {
      "country": "Gambia",
      "states": ["Banjul", "Central River", "Lower River", "North Bank", "Upper River", "Western"]
    },
    {
      "country": "Georgia",
      "states": []
    },
    {
      "country": "Germany",
      "states": ["Baden-Wuerttemberg", "Bayern", "Berlin", "Brandenburg", "Bremen", "Hamburg", "Hessen", "Mecklenburg-Vorpommern", "Niedersachsen", "Nordrhein-Westfalen", "Rheinland-Pfalz", "Saarland", "Sachsen", "Sachsen-Anhalt", "Schleswig-Holstein", "Thueringen"]
    },
    {
      "country": "Ghana",
      "states": ["Ashanti", "Brong-Ahafo", "Central", "Eastern", "Greater Accra", "Northern", "Upper East", "Upper West", "Volta", "Western"]
    },
    {
      "country": "Greece",
      "states": ["Agion Oros", "Achaia", "Aitolia kai Akarmania", "Argolis", "Arkadia", "Arta", "Attiki", "Chalkidiki", "Chanion", "Chios", "Dodekanisos", "Drama", "Evros", "Evrytania", "Evvoia", "Florina", "Fokidos", "Fthiotis", "Grevena", "Ileia", "Imathia", "Ioannina", "Irakleion", "Karditsa", "Kastoria", "Kavala", "Kefallinia", "Kerkyra", "Kilkis", "Korinthia", "Kozani", "Kyklades", "Lakonia", "Larisa", "Lasithi", "Lefkas", "Lesvos", "Magnisia", "Messinia", "Pella", "Pieria", "Preveza", "Rethynnis", "Rodopi", "Samos", "Serrai", "Thesprotia", "Thessaloniki", "Trikala", "Voiotia", "Xanthi", "Zakynthos"]
    },
    {
      "country": "Greenland",
      "states": ["Avannaa (Nordgronland)", "Tunu (Ostgronland)", "Kitaa (Vestgronland)"]
    },
    {
      "country": "Grenada",
      "states": ["Carriacou and Petit Martinique", "Saint Andrew", "Saint David", "Saint George", "Saint John", "Saint Mark", "Saint Patrick"]
    },
    {
      "country": "Guatemala",
      "states": ["Alta Verapaz", "Baja Verapaz", "Chimaltenango", "Chiquimula", "El Progreso", "Escuintla", "Guatemala", "Huehuetenango", "Izabal", "Jalapa", "Jutiapa", "Peten", "Quetzaltenango", "Quiche", "Retalhuleu", "Sacatepequez", "San Marcos", "Santa Rosa", "Solola", "Suchitepequez", "Totonicapan", "Zacapa"]
    },
    {
      "country": "Guinea",
      "states": ["Beyla", "Boffa", "Boke", "Conakry", "Coyah", "Dabola", "Dalaba", "Dinguiraye", "Dubreka", "Faranah", "Forecariah", "Fria", "Gaoual", "Gueckedou", "Kankan", "Kerouane", "Kindia", "Kissidougou", "Koubia", "Koundara", "Kouroussa", "Labe", "Lelouma", "Lola", "Macenta", "Mali", "Mamou", "Mandiana", "Nzerekore", "Pita", "Siguiri", "Telimele", "Tougue", "Yomou"]
    },
    {
      "country": "Guinea-Bissau",
      "states": ["Bafata", "Biombo", "Bissau", "Bolama", "Cacheu", "Gabu", "Oio", "Quinara", "Tombali"]
    },
    {
      "country": "Guyana",
      "states": ["Barima-Waini", "Cuyuni-Mazaruni", "Demerara-Mahaica", "East Berbice-Corentyne", "Essequibo Islands-West Demerara", "Mahaica-Berbice", "Pomeroon-Supenaam", "Potaro-Siparuni", "Upper Demerara-Berbice", "Upper Takutu-Upper Essequibo"]
    },
    {
      "country": "Haiti",
      "states": ["Artibonite", "Centre", "Grand Anse", "Nord", "Nord-Est", "Nord-Ouest", "Ouest", "Sud", "Sud-Est"]
    },
    {
      "country": "Honduras",
      "states": ["Atlantida", "Choluteca", "Colon", "Comayagua", "Copan", "Cortes", "El Paraiso", "Francisco Morazan", "Gracias a Dios", "Intibuca", "Islas de la Bahia", "La Paz", "Lempira", "Ocotepeque", "Olancho", "Santa Barbara", "Valle", "Yoro"]
    },
    {
      "country": "Hong Kong",
      "states": []
    },
    {
      "country": "Hungary",
      "states": ["Bacs-Kiskun", "Baranya", "Bekes", "Borsod-Abauj-Zemplen", "Csongrad", "Fejer", "Gyor-Moson-Sopron", "Hajdu-Bihar", "Heves", "Jasz-Nagykun-Szolnok", "Komarom-Esztergom", "Nograd", "Pest", "Somogy", "Szabolcs-Szatmar-Bereg", "Tolna", "Vas", "Veszprem", "Zala", "Bekescsaba", "Debrecen", "Dunaujvaros", "Eger", "Gyor", "Hodmezovasarhely", "Kaposvar", "Kecskemet", "Miskolc", "Nagykanizsa", "Nyiregyhaza", "Pecs", "Sopron", "Szeged", "Szekesfehervar", "Szolnok", "Szombathely", "Tatabanya", "Veszprem", "Zalaegerszeg"]
    },
    {
      "country": "Iceland",
      "states": ["Austurland", "Hofudhborgarsvaedhi", "Nordhurland Eystra", "Nordhurland Vestra", "Sudhurland", "Sudhurnes", "Vestfirdhir", "Vesturland"]
    },
    {
      "country": "India",
      "states": ["Andaman and Nicobar Islands", "Andhra Pradesh", "Arunachal Pradesh", "Assam", "Bihar", "Chandigarh", "Chhattisgarh", "Dadra and Nagar Haveli", "Daman and Diu", "Delhi", "Goa", "Gujarat", "Haryana", "Himachal Pradesh", "Jammu and Kashmir", "Jharkhand", "Karnataka", "Kerala", "Lakshadweep", "Madhya Pradesh", "Maharashtra", "Manipur", "Meghalaya", "Mizoram", "Nagaland", "Orissa", "Pondicherry", "Punjab", "Rajasthan", "Sikkim", "Tamil Nadu", "Tripura", "Uttaranchal", "Uttar Pradesh", "West Bengal"]
    },
    {
      "country": "Indonesia",
      "states": ["Aceh", "Bali", "Banten", "Bengkulu", "Gorontalo", "Irian Jaya Barat", "Jakarta Raya", "Jambi", "Jawa Barat", "Jawa Tengah", "Jawa Timur", "Kalimantan Barat", "Kalimantan Selatan", "Kalimantan Tengah", "Kalimantan Timur", "Kepulauan Bangka Belitung", "Kepulauan Riau", "Lampung", "Maluku", "Maluku Utara", "Nusa Tenggara Barat", "Nusa Tenggara Timur", "Papua", "Riau", "Sulawesi Barat", "Sulawesi Selatan", "Sulawesi Tengah", "Sulawesi Tenggara", "Sulawesi Utara", "Sumatera Barat", "Sumatera Selatan", "Sumatera Utara", "Yogyakarta"]
    },
    {
      "country": "Iran",
      "states": ["Ardabil", "Azarbayjan-e Gharbi", "Azarbayjan-e Sharqi", "Bushehr", "Chahar Mahall va Bakhtiari", "Esfahan", "Fars", "Gilan", "Golestan", "Hamadan", "Hormozgan", "Ilam", "Kerman", "Kermanshah", "Khorasan-e Janubi", "Khorasan-e Razavi", "Khorasan-e Shemali", "Khuzestan", "Kohgiluyeh va Buyer Ahmad", "Kordestan", "Lorestan", "Markazi", "Mazandaran", "Qazvin", "Qom", "Semnan", "Sistan va Baluchestan", "Tehran", "Yazd", "Zanjan"]
    },
    {
      "country": "Iraq",
      "states": ["Al Anbar", "Al Basrah", "Al Muthanna", "Al Qadisiyah", "An Najaf", "Arbil", "As Sulaymaniyah", "At Tamim", "Babil", "Baghdad", "Dahuk", "Dhi Qar", "Diyala", "Karbala", "Maysan", "Ninawa", "Salah ad Din", "Wasit"]
    },
    {
      "country": "Ireland",
      "states": ["Carlow", "Cavan", "Clare", "Cork", "Donegal", "Dublin", "Galway", "Kerry", "Kildare", "Kilkenny", "Laois", "Leitrim", "Limerick", "Longford", "Louth", "Mayo", "Meath", "Monaghan", "Offaly", "Roscommon", "Sligo", "Tipperary", "Waterford", "Westmeath", "Wexford", "Wicklow"]
    },
    {
      "country": "Israel",
      "states": ["Central", "Haifa", "Jerusalem", "Northern", "Southern", "Tel Aviv"]
    },
    {
      "country": "Italy",
      "states": ["Abruzzo", "Basilicata", "Calabria", "Campania", "Emilia-Romagna", "Friuli-Venezia Giulia", "Lazio", "Liguria", "Lombardia", "Marche", "Molise", "Piemonte", "Puglia", "Sardegna", "Sicilia", "Toscana", "Trentino-Alto Adige", "Umbria", "Valle dAosta", "Veneto"]
    },
    {
      "country": "Jamaica",
      "states": ["Clarendon", "Hanover", "Kingston", "Manchester", "Portland", "Saint Andrew", "Saint Ann", "Saint Catherine", "Saint Elizabeth", "Saint James", "Saint Mary", "Saint Thomas", "Trelawny", "Westmoreland"]
    },
    {
      "country": "Japan",
      "states": ["Aichi", "Akita", "Aomori", "Chiba", "Ehime", "Fukui", "Fukuoka", "Fukushima", "Gifu", "Gumma", "Hiroshima", "Hokkaido", "Hyogo", "Ibaraki", "Ishikawa", "Iwate", "Kagawa", "Kagoshima", "Kanagawa", "Kochi", "Kumamoto", "Kyoto", "Mie", "Miyagi", "Miyazaki", "Nagano", "Nagasaki", "Nara", "Niigata", "Oita", "Okayama", "Okinawa", "Osaka", "Saga", "Saitama", "Shiga", "Shimane", "Shizuoka", "Tochigi", "Tokushima", "Tokyo", "Tottori", "Toyama", "Wakayama", "Yamagata", "Yamaguchi", "Yamanashi"]
    },
    {
      "country": "Jordan",
      "states": ["Ajlun", "Al Aqabah", "Al Balqa", "Al Karak", "Al Mafraq", "Amman", "At Tafilah", "Az Zarqa", "Irbid", "Jarash", "Maan", "Madaba"]
    },
    {
      "country": "Kazakhstan",
      "states": ["Almaty Oblysy", "Almaty Qalasy", "Aqmola Oblysy", "Aqtobe Oblysy", "Astana Qalasy", "Atyrau Oblysy", "Batys Qazaqstan Oblysy", "Bayqongyr Qalasy", "Mangghystau Oblysy", "Ongtustik Qazaqstan Oblysy", "Pavlodar Oblysy", "Qaraghandy Oblysy", "Qostanay Oblysy", "Qyzylorda Oblysy", "Shyghys Qazaqstan Oblysy", "Soltustik Qazaqstan Oblysy", "Zhambyl Oblysy"]
    },
    {
      "country": "Kenya",
      "states": ["Central", "Coast", "Eastern", "Nairobi Area", "North Eastern", "Nyanza", "Rift Valley", "Western"]
    },
    {
      "country": "Kiribati",
      "states": []
    },
    {
      "country": "Korea North",
      "states": ["Chagang", "North Hamgyong", "South Hamgyong", "North Hwanghae", "South Hwanghae", "Kangwon", "North Pyongan", "South Pyongan", "Yanggang", "Kaesong", "Najin", "Nampo", "Pyongyang"]
    },
    {
      "country": "Korea South",
      "states": ["Seoul", "Busan City", "Daegu City", "Incheon City", "Gwangju City", "Daejeon City", "Ulsan", "Gyeonggi Province", "Gangwon Province", "North Chungcheong Province", "South Chungcheong Province", "North Jeolla Province", "South Jeolla Province", "North Gyeongsang Province", "South Gyeongsang Province", "Jeju"]
    },
    {
      "country": "Kuwait",
      "states": ["Al Ahmadi", "Al Farwaniyah", "Al Asimah", "Al Jahra", "Hawalli", "Mubarak Al-Kabeer"]
    },
    {
      "country": "Kyrgyzstan",
      "states": ["Batken Oblasty", "Bishkek Shaary", "Chuy Oblasty", "Jalal-Abad Oblasty", "Naryn Oblasty", "Osh Oblasty", "Talas Oblasty", "Ysyk-Kol Oblasty"]
    },
    {
      "country": "Laos",
      "states": ["Attapu", "Bokeo", "Bolikhamxai", "Champasak", "Houaphan", "Khammouan", "Louangnamtha", "Louangphrabang", "Oudomxai", "Phongsali", "Salavan", "Savannakhet", "Viangchan", "Viangchan", "Xaignabouli", "Xaisomboun", "Xekong", "Xiangkhoang"]
    },
    {
      "country": "Latvia",
      "states": ["Aizkraukles Rajons", "Aluksnes Rajons", "Balvu Rajons", "Bauskas Rajons", "Cesu Rajons", "Daugavpils", "Daugavpils Rajons", "Dobeles Rajons", "Gulbenes Rajons", "Jekabpils Rajons", "Jelgava", "Jelgavas Rajons", "Jurmala", "Kraslavas Rajons", "Kuldigas Rajons", "Liepaja", "Liepajas Rajons", "Limbazu Rajons", "Ludzas Rajons", "Madonas Rajons", "Ogres Rajons", "Preilu Rajons", "Rezekne", "Rezeknes Rajons", "Riga", "Rigas Rajons", "Saldus Rajons", "Talsu Rajons", "Tukuma Rajons", "Valkas Rajons", "Valmieras Rajons", "Ventspils", "Ventspils Rajons"]
    },
    {
      "country": "Lebanon",
      "states": ["Beyrouth", "Beqaa", "Liban-Nord", "Liban-Sud", "Mont-Liban", "Nabatiye"]
    },
    {
      "country": "Lesotho",
      "states": ["Berea", "Butha-Buthe", "Leribe", "Mafeteng", "Maseru", "Mohales Hoek", "Mokhotlong", "Qachas Nek", "Quthing", "Thaba-Tseka"]
    },
    {
      "country": "Liberia",
      "states": ["Bomi", "Bong", "Gbarpolu", "Grand Bassa", "Grand Cape Mount", "Grand Gedeh", "Grand Kru", "Lofa", "Margibi", "Maryland", "Montserrado", "Nimba", "River Cess", "River Gee", "Sinoe"]
    },
    {
      "country": "Libya",
      "states": ["Ajdabiya", "Al Aziziyah", "Al Fatih", "Al Jabal al Akhdar", "Al Jufrah", "Al Khums", "Al Kufrah", "An Nuqat al Khams", "Ash Shati", "Awbari", "Az Zawiyah", "Banghazi", "Darnah", "Ghadamis", "Gharyan", "Misratah", "Murzuq", "Sabha", "Sawfajjin", "Surt", "Tarabulus", "Tarhunah", "Tubruq", "Yafran", "Zlitan"]
    },
    {
      "country": "Liechtenstein",
      "states": ["Balzers", "Eschen", "Gamprin", "Mauren", "Planken", "Ruggell", "Schaan", "Schellenberg", "Triesen", "Triesenberg", "Vaduz"]
    },
    {
      "country": "Lithuania",
      "states": ["Alytaus", "Kauno", "Klaipedos", "Marijampoles", "Panevezio", "Siauliu", "Taurages", "Telsiu", "Utenos", "Vilniaus"]
    },
    {
      "country": "Luxembourg",
      "states": ["Diekirch", "Grevenmacher", "Luxembourg"]
    },
    {
      "country": "Macedonia",
      "states": ["Aerodrom", "Aracinovo", "Berovo", "Bitola", "Bogdanci", "Bogovinje", "Bosilovo", "Brvenica", "Butel", "Cair", "Caska", "Centar", "Centar Zupa", "Cesinovo", "Cucer-Sandevo", "Debar", "Debartsa", "Delcevo", "Demir Hisar", "Demir Kapija", "Dojran", "Dolneni", "Drugovo", "Gazi Baba", "Gevgelija", "Gjorce Petrov", "Gostivar", "Gradsko", "Ilinden", "Jegunovce", "Karbinci", "Karpos", "Kavadarci", "Kicevo", "Kisela Voda", "Kocani", "Konce", "Kratovo", "Kriva Palanka", "Krivogastani", "Krusevo", "Kumanovo", "Lipkovo", "Lozovo", "Makedonska Kamenica", "Makedonski Brod", "Mavrovo i Rastusa", "Mogila", "Negotino", "Novaci", "Novo Selo", "Ohrid", "Oslomej", "Pehcevo", "Petrovec", "Plasnica", "Prilep", "Probistip", "Radovis", "Rankovce", "Resen", "Rosoman", "Saraj", "Skopje", "Sopiste", "Staro Nagoricane", "Stip", "Struga", "Strumica", "Studenicani", "Suto Orizari", "Sveti Nikole", "Tearce", "Tetovo", "Valandovo", "Vasilevo", "Veles", "Vevcani", "Vinica", "Vranestica", "Vrapciste", "Zajas", "Zelenikovo", "Zelino", "Zrnovci"]
    },
    {
      "country": "Madagascar",
      "states": ["Antananarivo", "Antsiranana", "Fianarantsoa", "Mahajanga", "Toamasina", "Toliara"]
    },
    {
      "country": "Malawi",
      "states": ["Balaka", "Blantyre", "Chikwawa", "Chiradzulu", "Chitipa", "Dedza", "Dowa", "Karonga", "Kasungu", "Likoma", "Lilongwe", "Machinga", "Mangochi", "Mchinji", "Mulanje", "Mwanza", "Mzimba", "Ntcheu", "Nkhata Bay", "Nkhotakota", "Nsanje", "Ntchisi", "Phalombe", "Rumphi", "Salima", "Thyolo", "Zomba"]
    },
    {
      "country": "Malaysia",
      "states": ["Johor", "Kedah", "Kelantan", "Kuala Lumpur", "Labuan", "Malacca", "Negeri Sembilan", "Pahang", "Perak", "Perlis", "Penang", "Sabah", "Sarawak", "Selangor", "Terengganu"]
    },
    {
      "country": "Maldives",
      "states": ["Alifu", "Baa", "Dhaalu", "Faafu", "Gaafu Alifu", "Gaafu Dhaalu", "Gnaviyani", "Haa Alifu", "Haa Dhaalu", "Kaafu", "Laamu", "Lhaviyani", "Maale", "Meemu", "Noonu", "Raa", "Seenu", "Shaviyani", "Thaa", "Vaavu"]
    },
    {
      "country": "Mali",
      "states": ["Bamako (Capital)", "Gao", "Kayes", "Kidal", "Koulikoro", "Mopti", "Segou", "Sikasso", "Tombouctou"]
    },
    {
      "country": "Malta",
      "states": []
    },
    {
      "country": "Marshall Islands",
      "states": []
    },
    {
      "country": "Mauritania",
      "states": ["Adrar", "Assaba", "Brakna", "Dakhlet Nouadhibou", "Gorgol", "Guidimaka", "Hodh Ech Chargui", "Hodh El Gharbi", "Inchiri", "Nouakchott", "Tagant", "Tiris Zemmour", "Trarza"]
    },
    {
      "country": "Mauritius",
      "states": ["Agalega Islands", "Black River", "Cargados Carajos Shoals", "Flacq", "Grand Port", "Moka", "Pamplemousses", "Plaines Wilhems", "Port Louis", "Riviere du Rempart", "Rodrigues", "Savanne"]
    },
    {
      "country": "Mexico",
      "states": ["Aguascalientes", "Baja California", "Baja California Sur", "Campeche", "Chiapas", "Chihuahua", "Coahuila de Zaragoza", "Colima", "Distrito Federal", "Durango", "Guanajuato", "Guerrero", "Hidalgo", "Jalisco", "Mexico", "Michoacan de Ocampo", "Morelos", "Nayarit", "Nuevo Leon", "Oaxaca", "Puebla", "Queretaro de Arteaga", "Quintana Roo", "San Luis Potosi", "Sinaloa", "Sonora", "Tabasco", "Tamaulipas", "Tlaxcala", "Veracruz-Llave", "Yucatan", "Zacatecas"]
    },
    {
      "country": "Micronesia",
      "states": []
    },
    {
      "country": "Moldova",
      "states": ["Anenii Noi", "Basarabeasca", "Briceni", "Cahul", "Cantemir", "Calarasi", "Causeni", "Cimislia", "Criuleni", "Donduseni", "Drochia", "Dubasari", "Edinet", "Falesti", "Floresti", "Glodeni", "Hincesti", "Ialoveni", "Leova", "Nisporeni", "Ocnita", "Orhei", "Rezina", "Riscani", "Singerei", "Soldanesti", "Soroca", "Stefan-Voda", "Straseni", "Taraclia", "Telenesti", "Ungheni", "Balti", "Bender", "Chisinau", "Gagauzia", "Stinga Nistrului"]
    },
    {
      "country": "Mongolia",
      "states": ["Arhangay", "Bayanhongor", "Bayan-Olgiy", "Bulgan", "Darhan Uul", "Dornod", "Dornogovi", "Dundgovi", "Dzavhan", "Govi-Altay", "Govi-Sumber", "Hentiy", "Hovd", "Hovsgol", "Omnogovi", "Orhon", "Ovorhangay", "Selenge", "Suhbaatar", "Tov", "Ulaanbaatar", "Uvs"]
    },
    {
      "country": "Morocco",
      "states": ["Agadir", "Al Hoceima", "Azilal", "Beni Mellal", "Ben Slimane", "Boulemane", "Casablanca", "Chaouen", "El Jadida", "El Kelaa des Sraghna", "Er Rachidia", "Essaouira", "Fes", "Figuig", "Guelmim", "Ifrane", "Kenitra", "Khemisset", "Khenifra", "Khouribga", "Laayoune", "Larache", "Marrakech", "Meknes", "Nador", "Ouarzazate", "Oujda", "Rabat-Sale", "Safi", "Settat", "Sidi Kacem", "Tangier", "Tan-Tan", "Taounate", "Taroudannt", "Tata", "Taza", "Tetouan", "Tiznit"]
    },
    {
      "country": "Monaco",
      "states": []
    },
    {
      "country": "Mozambique",
      "states": ["Cabo Delgado", "Gaza", "Inhambane", "Manica", "Maputo", "Cidade de Maputo", "Nampula", "Niassa", "Sofala", "Tete", "Zambezia"]
    },
    {
      "country": "Namibia",
      "states": ["Caprivi", "Erongo", "Hardap", "Karas", "Khomas", "Kunene", "Ohangwena", "Okavango", "Omaheke", "Omusati", "Oshana", "Oshikoto", "Otjozondjupa"]
    },
    {
      "country": "Nauru",
      "states": []
    },
    {
      "country": "Nepal",
      "states": ["Bagmati", "Bheri", "Dhawalagiri", "Gandaki", "Janakpur", "Karnali", "Kosi", "Lumbini", "Mahakali", "Mechi", "Narayani", "Rapti", "Sagarmatha", "Seti"]
    },
    {
      "country": "Netherlands",
      "states": ["Drenthe", "Flevoland", "Friesland", "Gelderland", "Groningen", "Limburg", "Noord-Brabant", "Noord-Holland", "Overijssel", "Utrecht", "Zeeland", "Zuid-Holland"]
    },
    {
      "country": "New Zealand",
      "states": ["Auckland", "Bay of Plenty", "Canterbury", "Chatham Islands", "Gisborne", "Hawkes Bay", "Manawatu-Wanganui", "Marlborough", "Nelson", "Northland", "Otago", "Southland", "Taranaki", "Tasman", "Waikato", "Wellington", "West Coast"]
    },
    {
      "country": "Nicaragua",
      "states": ["Atlantico Norte", "Atlantico Sur", "Boaco", "Carazo", "Chinandega", "Chontales", "Esteli", "Granada", "Jinotega", "Leon", "Madriz", "Managua", "Masaya", "Matagalpa", "Nueva Segovia", "Rio San Juan", "Rivas"]
    },
    {
      "country": "Niger",
      "states": ["Agadez", "Diffa", "Dosso", "Maradi", "Niamey", "Tahoua", "Tillaberi", "Zinder"]
    },
    {
      "country": "Nigeria",
      "states": ["Abia", "Abuja Federal Capital", "Adamawa", "Akwa Ibom", "Anambra", "Bauchi", "Bayelsa", "Benue", "Borno", "Cross River", "Delta", "Ebonyi", "Edo", "Ekiti", "Enugu", "Gombe", "Imo", "Jigawa", "Kaduna", "Kano", "Katsina", "Kebbi", "Kogi", "Kwara", "Lagos", "Nassarawa", "Niger", "Ogun", "Ondo", "Osun", "Oyo", "Plateau", "Rivers", "Sokoto", "Taraba", "Yobe", "Zamfara"]
    },
    {
      "country": "Norway",
      "states": ["Akershus", "Aust-Agder", "Buskerud", "Finnmark", "Hedmark", "Hordaland", "More og Romsdal", "Nordland", "Nord-Trondelag", "Oppland", "Oslo", "Ostfold", "Rogaland", "Sogn og Fjordane", "Sor-Trondelag", "Telemark", "Troms", "Vest-Agder", "Vestfold"]
    },
    {
      "country": "Oman",
      "states": ["Ad Dakhiliyah", "Al Batinah", "Al Wusta", "Ash Sharqiyah", "Az Zahirah", "Masqat", "Musandam", "Dhofar"]
    },
    {
      "country": "Pakistan",
      "states": ["Balochistan", "North-West Frontier Province", "Punjab", "Sindh", "Islamabad Capital Territory", "Federally Administered Tribal Areas"]
    },
    {
      "country": "Panama",
      "states": ["Bocas del Toro", "Chiriqui", "Cocle", "Colon", "Darien", "Herrera", "Los Santos", "Panama", "San Blas", "Veraguas"]
    },
    {
      "country": "Papua New Guinea",
      "states": ["Bougainville", "Central", "Chimbu", "Eastern Highlands", "East New Britain", "East Sepik", "Enga", "Gulf", "Madang", "Manus", "Milne Bay", "Morobe", "National Capital", "New Ireland", "Northern", "Sandaun", "Southern Highlands", "Western", "Western Highlands", "West New Britain"]
    },
    {
      "country": "Paraguay",
      "states": ["Alto Paraguay", "Alto Parana", "Amambay", "Asuncion", "Boqueron", "Caaguazu", "Caazapa", "Canindeyu", "Central", "Concepcion", "Cordillera", "Guaira", "Itapua", "Misiones", "Neembucu", "Paraguari", "Presidente Hayes", "San Pedro"]
    },
    {
      "country": "Peru",
      "states": ["Amazonas", "Ancash", "Apurimac", "Arequipa", "Ayacucho", "Cajamarca", "Callao", "Cusco", "Huancavelica", "Huanuco", "Ica", "Junin", "La Libertad", "Lambayeque", "Lima", "Loreto", "Madre de Dios", "Moquegua", "Pasco", "Piura", "Puno", "San Martin", "Tacna", "Tumbes", "Ucayali"]
    },
    {
      "country": "Philippines",
      "states": ["Abra", "Agusan del Norte", "Agusan del Sur", "Aklan", "Albay", "Antique", "Apayao", "Aurora", "Basilan", "Bataan", "Batanes", "Batangas", "Biliran", "Benguet", "Bohol", "Bukidnon", "Bulacan", "Cagayan", "Camarines Norte", "Camarines Sur", "Camiguin", "Capiz", "Catanduanes", "Cavite", "Cebu", "Compostela", "Davao del Norte", "Davao del Sur", "Davao Oriental", "Eastern Samar", "Guimaras", "Ifugao", "Ilocos Norte", "Ilocos Sur", "Iloilo", "Isabela", "Kalinga", "Laguna", "Lanao del Norte", "Lanao del Sur", "La Union", "Leyte", "Maguindanao", "Marinduque", "Masbate", "Mindoro Occidental", "Mindoro Oriental", "Misamis Occidental", "Misamis Oriental", "Mountain Province", "Negros Occidental", "Negros Oriental", "North Cotabato", "Northern Samar", "Nueva Ecija", "Nueva Vizcaya", "Palawan", "Pampanga", "Pangasinan", "Quezon", "Quirino", "Rizal", "Romblon", "Samar", "Sarangani", "Siquijor", "Sorsogon", "South Cotabato", "Southern Leyte", "Sultan Kudarat", "Sulu", "Surigao del Norte", "Surigao del Sur", "Tarlac", "Tawi-Tawi", "Zambales", "Zamboanga del Norte", "Zamboanga del Sur", "Zamboanga Sibugay"]
    },
    {
      "country": "Poland",
      "states": ["Greater Poland (Wielkopolskie)", "Kuyavian-Pomeranian (Kujawsko-Pomorskie)", "Lesser Poland (Malopolskie)", "Lodz (Lodzkie)", "Lower Silesian (Dolnoslaskie)", "Lublin (Lubelskie)", "Lubusz (Lubuskie)", "Masovian (Mazowieckie)", "Opole (Opolskie)", "Podlasie (Podlaskie)", "Pomeranian (Pomorskie)", "Silesian (Slaskie)", "Subcarpathian (Podkarpackie)", "Swietokrzyskie (Swietokrzyskie)", "Warmian-Masurian (Warminsko-Mazurskie)", "West Pomeranian (Zachodniopomorskie)"]
    },
    {
      "country": "Portugal",
      "states": ["Aveiro", "Acores", "Beja", "Braga", "Braganca", "Castelo Branco", "Coimbra", "Evora", "Faro", "Guarda", "Leiria", "Lisboa", "Madeira", "Portalegre", "Porto", "Santarem", "Setubal", "Viana do Castelo", "Vila Real", "Viseu"]
    },
    {
      "country": "Qatar",
      "states": ["Ad Dawhah", "Al Ghuwayriyah", "Al Jumayliyah", "Al Khawr", "Al Wakrah", "Ar Rayyan", "Jarayan al Batinah", "Madinat ash Shamal", "Umm Said", "Umm Salal"]
    },
    {
      "country": "Romania",
      "states": ["Alba", "Arad", "Arges", "Bacau", "Bihor", "Bistrita-Nasaud", "Botosani", "Braila", "Brasov", "Bucuresti", "Buzau", "Calarasi", "Caras-Severin", "Cluj", "Constanta", "Covasna", "Dimbovita", "Dolj", "Galati", "Gorj", "Giurgiu", "Harghita", "Hunedoara", "Ialomita", "Iasi", "Ilfov", "Maramures", "Mehedinti", "Mures", "Neamt", "Olt", "Prahova", "Salaj", "Satu Mare", "Sibiu", "Suceava", "Teleorman", "Timis", "Tulcea", "Vaslui", "Vilcea", "Vrancea"]
    },
    {
      "country": "Russia",
      "states": ["Amur", "Arkhangelsk", "Astrakhan", "Belgorod", "Bryansk", "Chelyabinsk", "Chita", "Irkutsk", "Ivanovo", "Kaliningrad", "Kaluga", "Kamchatka", "Kemerovo", "Kirov", "Kostroma", "Kurgan", "Kursk", "Leningrad", "Lipetsk", "Magadan", "Moscow", "Murmansk", "Nizhniy Novgorod", "Novgorod", "Novosibirsk", "Omsk", "Orenburg", "Orel", "Penza", "Perm", "Pskov", "Rostov", "Ryazan", "Sakhalin", "Samara", "Saratov", "Smolensk", "Sverdlovsk", "Tambov", "Tomsk", "Tula", "Tver", "Tyumen", "Ulyanovsk", "Vladimir", "Volgograd", "Vologda", "Voronezh", "Yaroslavl", "Adygeya", "Altay", "Bashkortostan", "Buryatiya", "Chechnya", "Chuvashiya", "Dagestan", "Ingushetiya", "Kabardino-Balkariya", "Kalmykiya", "Karachayevo-Cherkesiya", "Kareliya", "Khakasiya", "Komi", "Mariy-El", "Mordoviya", "Sakha", "North Ossetia", "Tatarstan", "Tyva", "Udmurtiya", "Aga Buryat", "Chukotka", "Evenk", "Khanty-Mansi", "Komi-Permyak", "Koryak", "Nenets", "Taymyr", "Ust-Orda Buryat", "Yamalo-Nenets", "Altay", "Khabarovsk", "Krasnodar", "Krasnoyarsk", "Primorskiy", "Stavropol", "Moscow", "St. Petersburg", "Yevrey"]
    },
    {
      "country": "Rwanda",
      "states": ["Butare", "Byumba", "Cyangugu", "Gikongoro", "Gisenyi", "Gitarama", "Kibungo", "Kibuye", "Kigali Rurale", "Kigali-ville", "Umutara", "Ruhengeri"]
    },
    {
      "country": "Samoa",
      "states": ["Aana", "Aiga-i-le-Tai", "Atua", "Faasaleleaga", "Gagaemauga", "Gagaifomauga", "Palauli", "Satupaitea", "Tuamasaga", "Vaa-o-Fonoti", "Vaisigano"]
    },
    {
      "country": "San Marino",
      "states": ["Acquaviva", "Borgo Maggiore", "Chiesanuova", "Domagnano", "Faetano", "Fiorentino", "Montegiardino", "San Marino Citta", "Serravalle"]
    },
    {
      "country": "Sao Tome",
      "states": []
    },
    {
      "country": "Saudi Arabia",
      "states": ["Al Bahah", "Al Hudud ash Shamaliyah", "Al Jawf", "Al Madinah", "Al Qasim", "Ar Riyad", "Ash Sharqiyah", "Asir", "Hail", "Jizan", "Makkah", "Najran", "Tabuk"]
    },
    {
      "country": "Senegal",
      "states": ["Dakar", "Diourbel", "Fatick", "Kaolack", "Kolda", "Louga", "Matam", "Saint-Louis", "Tambacounda", "Thies", "Ziguinchor"]
    },
    {
      "country": "Serbia and Montenegro",
      "states": ["Kosovo", "Montenegro", "Serbia", "Vojvodina"]
    },
    {
      "country": "Seychelles",
      "states": ["Anse aux Pins", "Anse Boileau", "Anse Etoile", "Anse Louis", "Anse Royale", "Baie Lazare", "Baie Sainte Anne", "Beau Vallon", "Bel Air", "Bel Ombre", "Cascade", "Glacis", "Grand Anse", "Grand Anse", "La Digue", "La Riviere Anglaise", "Mont Buxton", "Mont Fleuri", "Plaisance", "Pointe La Rue", "Port Glaud", "Saint Louis", "Takamaka"]
    },
    {
      "country": "Sierra Leone",
      "states": []
    },
    {
      "country": "Singapore",
      "states": []
    },
    {
      "country": "Slovakia",
      "states": ["Banskobystricky", "Bratislavsky", "Kosicky", "Nitriansky", "Presovsky", "Trenciansky", "Trnavsky", "Zilinsky"]
    },
    {
      "country": "Slovenia",
      "states": ["Ajdovscina", "Beltinci", "Benedikt", "Bistrica ob Sotli", "Bled", "Bloke", "Bohinj", "Borovnica", "Bovec", "Braslovce", "Brda", "Brezice", "Brezovica", "Cankova", "Celje", "Cerklje na Gorenjskem", "Cerknica", "Cerkno", "Cerkvenjak", "Crensovci", "Crna na Koroskem", "Crnomelj", "Destrnik", "Divaca", "Dobje", "Dobrepolje", "Dobrna", "Dobrova-Horjul-Polhov Gradec", "Dobrovnik-Dobronak", "Dolenjske Toplice", "Dol pri Ljubljani", "Domzale", "Dornava", "Dravograd", "Duplek", "Gorenja Vas-Poljane", "Gorisnica", "Gornja Radgona", "Gornji Grad", "Gornji Petrovci", "Grad", "Grosuplje", "Hajdina", "Hoce-Slivnica", "Hodos-Hodos", "Horjul", "Hrastnik", "Hrpelje-Kozina", "Idrija", "Ig", "Ilirska Bistrica", "Ivancna Gorica", "Izola-Isola", "Jesenice", "Jezersko", "Jursinci", "Kamnik", "Kanal", "Kidricevo", "Kobarid", "Kobilje", "Kocevje", "Komen", "Komenda", "Koper-Capodistria", "Kostel", "Kozje", "Kranj", "Kranjska Gora", "Krizevci", "Krsko", "Kungota", "Kuzma", "Lasko", "Lenart", "Lendava-Lendva", "Litija", "Ljubljana", "Ljubno", "Ljutomer", "Logatec", "Loska Dolina", "Loski Potok", "Lovrenc na Pohorju", "Luce", "Lukovica", "Majsperk", "Maribor", "Markovci", "Medvode", "Menges", "Metlika", "Mezica", "Miklavz na Dravskem Polju", "Miren-Kostanjevica", "Mirna Pec", "Mislinja", "Moravce", "Moravske Toplice", "Mozirje", "Murska Sobota", "Muta", "Naklo", "Nazarje", "Nova Gorica", "Novo Mesto", "Odranci", "Oplotnica", "Ormoz", "Osilnica", "Pesnica", "Piran-Pirano", "Pivka", "Podcetrtek", "Podlehnik", "Podvelka", "Polzela", "Postojna", "Prebold", "Preddvor", "Prevalje", "Ptuj", "Puconci", "Race-Fram", "Radece", "Radenci", "Radlje ob Dravi", "Radovljica", "Ravne na Koroskem", "Razkrizje", "Ribnica", "Ribnica na Pohorju", "Rogasovci", "Rogaska Slatina", "Rogatec", "Ruse", "Salovci", "Selnica ob Dravi", "Semic", "Sempeter-Vrtojba", "Sencur", "Sentilj", "Sentjernej", "Sentjur pri Celju", "Sevnica", "Sezana", "Skocjan", "Skofja Loka", "Skofljica", "Slovenj Gradec", "Slovenska Bistrica", "Slovenske Konjice", "Smarje pri Jelsah", "Smartno ob Paki", "Smartno pri Litiji", "Sodrazica", "Solcava", "Sostanj", "Starse", "Store", "Sveta Ana", "Sveti Andraz v Slovenskih Goricah", "Sveti Jurij", "Tabor", "Tisina", "Tolmin", "Trbovlje", "Trebnje", "Trnovska Vas", "Trzic", "Trzin", "Turnisce", "Velenje", "Velika Polana", "Velike Lasce", "Verzej", "Videm", "Vipava", "Vitanje", "Vodice", "Vojnik", "Vransko", "Vrhnika", "Vuzenica", "Zagorje ob Savi", "Zalec", "Zavrc", "Zelezniki", "Zetale", "Ziri", "Zirovnica", "Zuzemberk", "Zrece"]
    },
    {
      "country": "Solomon Islands",
      "states": ["Central", "Choiseul", "Guadalcanal", "Honiara", "Isabel", "Makira", "Malaita", "Rennell and Bellona", "Temotu", "Western"]
    },
    {
      "country": "Somalia",
      "states": ["Awdal", "Bakool", "Banaadir", "Bari", "Bay", "Galguduud", "Gedo", "Hiiraan", "Jubbada Dhexe", "Jubbada Hoose", "Mudug", "Nugaal", "Sanaag", "Shabeellaha Dhexe", "Shabeellaha Hoose", "Sool", "Togdheer", "Woqooyi Galbeed"]
    },
    {
      "country": "South Africa",
      "states": ["Eastern Cape", "Free State", "Gauteng", "KwaZulu-Natal", "Limpopo", "Mpumalanga", "North-West", "Northern Cape", "Western Cape"]
    },
    {
      "country": "Spain",
      "states": ["Andalucia", "Aragon", "Asturias", "Baleares", "Ceuta", "Canarias", "Cantabria", "Castilla-La Mancha", "Castilla y Leon", "Cataluna", "Comunidad Valenciana", "Extremadura", "Galicia", "La Rioja", "Madrid", "Melilla", "Murcia", "Navarra", "Pais Vasco"]
    },
    {
      "country": "Sri Lanka",
      "states": ["Central", "North Central", "North Eastern", "North Western", "Sabaragamuwa", "Southern", "Uva", "Western"]
    },
    {
      "country": "Sudan",
      "states": ["Aali an Nil", "Al Bahr al Ahmar", "Al Buhayrat", "Al Jazirah", "Al Khartum", "Al Qadarif", "Al Wahdah", "An Nil al Abyad", "An Nil al Azraq", "Ash Shamaliyah", "Bahr al Jabal", "Gharb al Istiwaiyah", "Gharb Bahr al Ghazal", "Gharb Darfur", "Gharb Kurdufan", "Janub Darfur", "Janub Kurdufan", "Junqali", "Kassala", "Nahr an Nil", "Shamal Bahr al Ghazal", "Shamal Darfur", "Shamal Kurdufan", "Sharq al Istiwaiyah", "Sinnar", "Warab"]
    },
    {
      "country": "Suriname",
      "states": ["Brokopondo", "Commewijne", "Coronie", "Marowijne", "Nickerie", "Para", "Paramaribo", "Saramacca", "Sipaliwini", "Wanica"]
    },
    {
      "country": "Swaziland",
      "states": ["Hhohho", "Lubombo", "Manzini", "Shiselweni"]
    },
    {
      "country": "Sweden",
      "states": ["Blekinge", "Dalarnas", "Gavleborgs", "Gotlands", "Hallands", "Jamtlands", "Jonkopings", "Kalmar", "Kronobergs", "Norrbottens", "Orebro", "Ostergotlands", "Skane", "Sodermanlands", "Stockholms", "Uppsala", "Varmlands", "Vasterbottens", "Vasternorrlands", "Vastmanlands", "Vastra Gotalands"]
    },
    {
      "country": "Switzerland",
      "states": ["Aargau", "Appenzell Ausser-Rhoden", "Appenzell Inner-Rhoden", "Basel-Landschaft", "Basel-Stadt", "Bern", "Fribourg", "Geneve", "Glarus", "Graubunden", "Jura", "Luzern", "Neuchatel", "Nidwalden", "Obwalden", "Sankt Gallen", "Schaffhausen", "Schwyz", "Solothurn", "Thurgau", "Ticino", "Uri", "Valais", "Vaud", "Zug", "Zurich"]
    },
    {
      "country": "Syria",
      "states": ["Al Hasakah", "Al Ladhiqiyah", "Al Qunaytirah", "Ar Raqqah", "As Suwayda", "Dara", "Dayr az Zawr", "Dimashq", "Halab", "Hamah", "Hims", "Idlib", "Rif Dimashq", "Tartus"]
    },
    {
      "country": "Taiwan",
      "states": ["Chang-hua", "Chia-i", "Hsin-chu", "Hua-lien", "I-lan", "Kao-hsiung", "Kin-men", "Lien-chiang", "Miao-li", "Nan-tou", "Peng-hu", "Ping-tung", "Tai-chung", "Tai-nan", "Tai-pei", "Tai-tung", "Tao-yuan", "Yun-lin", "Chia-i", "Chi-lung", "Hsin-chu", "Tai-chung", "Tai-nan", "Kao-hsiung city", "Tai-pei city"]
    },
    {
      "country": "Tajikistan",
      "states": []
    },
    {
      "country": "Tanzania",
      "states": ["Arusha", "Dar es Salaam", "Dodoma", "Iringa", "Kagera", "Kigoma", "Kilimanjaro", "Lindi", "Manyara", "Mara", "Mbeya", "Morogoro", "Mtwara", "Mwanza", "Pemba North", "Pemba South", "Pwani", "Rukwa", "Ruvuma", "Shinyanga", "Singida", "Tabora", "Tanga", "Zanzibar Central/South", "Zanzibar North", "Zanzibar Urban/West"]
    },
    {
      "country": "Thailand",
      "states": ["Amnat Charoen", "Ang Thong", "Buriram", "Chachoengsao", "Chai Nat", "Chaiyaphum", "Chanthaburi", "Chiang Mai", "Chiang Rai", "Chon Buri", "Chumphon", "Kalasin", "Kamphaeng Phet", "Kanchanaburi", "Khon Kaen", "Krabi", "Krung Thep Mahanakhon", "Lampang", "Lamphun", "Loei", "Lop Buri", "Mae Hong Son", "Maha Sarakham", "Mukdahan", "Nakhon Nayok", "Nakhon Pathom", "Nakhon Phanom", "Nakhon Ratchasima", "Nakhon Sawan", "Nakhon Si Thammarat", "Nan", "Narathiwat", "Nong Bua Lamphu", "Nong Khai", "Nonthaburi", "Pathum Thani", "Pattani", "Phangnga", "Phatthalung", "Phayao", "Phetchabun", "Phetchaburi", "Phichit", "Phitsanulok", "Phra Nakhon Si Ayutthaya", "Phrae", "Phuket", "Prachin Buri", "Prachuap Khiri Khan", "Ranong", "Ratchaburi", "Rayong", "Roi Et", "Sa Kaeo", "Sakon Nakhon", "Samut Prakan", "Samut Sakhon", "Samut Songkhram", "Sara Buri", "Satun", "Sing Buri", "Sisaket", "Songkhla", "Sukhothai", "Suphan Buri", "Surat Thani", "Surin", "Tak", "Trang", "Trat", "Ubon Ratchathani", "Udon Thani", "Uthai Thani", "Uttaradit", "Yala", "Yasothon"]
    },
    {
      "country": "Togo",
      "states": ["Kara", "Plateaux", "Savanes", "Centrale", "Maritime"]
    },
    {
      "country": "Tonga",
      "states": []
    },
    {
      "country": "Trinidad and Tobago",
      "states": ["Couva", "Diego Martin", "Mayaro", "Penal", "Princes Town", "Sangre Grande", "San Juan", "Siparia", "Tunapuna", "Port-of-Spain", "San Fernando", "Arima", "Point Fortin", "Chaguanas", "Tobago"]
    },
    {
      "country": "Tunisia",
      "states": ["Ariana (Aryanah)", "Beja (Bajah)", "Ben Arous (Bin Arus)", "Bizerte (Banzart)", "Gabes (Qabis)", "Gafsa (Qafsah)", "Jendouba (Jundubah)", "Kairouan (Al Qayrawan)", "Kasserine (Al Qasrayn)", "Kebili (Qibili)", "Kef (Al Kaf)", "Mahdia (Al Mahdiyah)", "Manouba (Manubah)", "Medenine (Madanin)", "Monastir (Al Munastir)", "Nabeul (Nabul)", "Sfax (Safaqis)", "Sidi Bou Zid (Sidi Bu Zayd)", "Siliana (Silyanah)", "Sousse (Susah)", "Tataouine (Tatawin)", "Tozeur (Tawzar)", "Tunis", "Zaghouan (Zaghwan)"]
    },
    {
      "country": "Turkey",
      "states": ["Adana", "Adiyaman", "Afyonkarahisar", "Agri", "Aksaray", "Amasya", "Ankara", "Antalya", "Ardahan", "Artvin", "Aydin", "Balikesir", "Bartin", "Batman", "Bayburt", "Bilecik", "Bingol", "Bitlis", "Bolu", "Burdur", "Bursa", "Canakkale", "Cankiri", "Corum", "Denizli", "Diyarbakir", "Duzce", "Edirne", "Elazig", "Erzincan", "Erzurum", "Eskisehir", "Gaziantep", "Giresun", "Gumushane", "Hakkari", "Hatay", "Igdir", "Isparta", "Istanbul", "Izmir", "Kahramanmaras", "Karabuk", "Karaman", "Kars", "Kastamonu", "Kayseri", "Kilis", "Kirikkale", "Kirklareli", "Kirsehir", "Kocaeli", "Konya", "Kutahya", "Malatya", "Manisa", "Mardin", "Mersin", "Mugla", "Mus", "Nevsehir", "Nigde", "Ordu", "Osmaniye", "Rize", "Sakarya", "Samsun", "Sanliurfa", "Siirt", "Sinop", "Sirnak", "Sivas", "Tekirdag", "Tokat", "Trabzon", "Tunceli", "Usak", "Van", "Yalova", "Yozgat", "Zonguldak"]
    },
    {
      "country": "Turkmenistan",
      "states": ["Ahal Welayaty (Ashgabat)", "Balkan Welayaty (Balkanabat)", "Dashoguz Welayaty", "Lebap Welayaty (Turkmenabat)", "Mary Welayaty"]
    },
    {
      "country": "Uganda",
      "states": ["Adjumani", "Apac", "Arua", "Bugiri", "Bundibugyo", "Bushenyi", "Busia", "Gulu", "Hoima", "Iganga", "Jinja", "Kabale", "Kabarole", "Kaberamaido", "Kalangala", "Kampala", "Kamuli", "Kamwenge", "Kanungu", "Kapchorwa", "Kasese", "Katakwi", "Kayunga", "Kibale", "Kiboga", "Kisoro", "Kitgum", "Kotido", "Kumi", "Kyenjojo", "Lira", "Luwero", "Masaka", "Masindi", "Mayuge", "Mbale", "Mbarara", "Moroto", "Moyo", "Mpigi", "Mubende", "Mukono", "Nakapiripirit", "Nakasongola", "Nebbi", "Ntungamo", "Pader", "Pallisa", "Rakai", "Rukungiri", "Sembabule", "Sironko", "Soroti", "Tororo", "Wakiso", "Yumbe"]
    },
    {
      "country": "Ukraine",
      "states": ["Cherkasy", "Chernihiv", "Chernivtsi", "Crimea", "Dnipropetrovsk", "Donetsk", "Ivano-Frankivsk", "Kharkiv", "Kherson", "Khmelnytskyy", "Kirovohrad", "Kiev", "Kyyiv", "Luhansk", "Lviv", "Mykolayiv", "Odesa", "Poltava", "Rivne", "Sevastopol", "Sumy", "Ternopil", "Vinnytsya", "Volyn", "Zakarpattya", "Zaporizhzhya", "Zhytomyr"]
    },
    {
      "country": "United Arab Emirates",
      "states": ["Abu Dhabi", "Ajman", "Al Fujayrah", "Sharjah", "Dubai", "Ras al Khaymah", "Umm al Qaywayn"]
    },
    {
      "country": "United Kingdom",
      "states": []
    },
    {
      "country": "United States",
      "states": ["Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "District of Columbia", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "Nevada", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Ohio", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "South Dakota", "Tennessee", "Texas", "Utah", "Vermont", "Virginia", "Washington", "West Virginia", "Wisconsin", "Wyoming"]
    },
    {
      "country": "Uruguay",
      "states": ["Artigas", "Canelones", "Cerro Largo", "Colonia", "Durazno", "Flores", "Florida", "Lavalleja", "Maldonado", "Montevideo", "Paysandu", "Rio Negro", "Rivera", "Rocha", "Salto", "San Jose", "Soriano", "Tacuarembo", "Treinta y Tres"]
    },
    {
      "country": "Uzbekistan",
      "states": ["Andijon Viloyati", "Buxoro Viloyati", "Fargona Viloyati", "Jizzax Viloyati", "Namangan Viloyati", "Navoiy Viloyati", "Qashqadaryo Viloyati", "Qaraqalpogiston Respublikasi", "Samarqand Viloyati", "Sirdaryo Viloyati", "Surxondaryo Viloyati", "Toshkent Shahri", "Toshkent Viloyati", "Xorazm Viloyati"]
    },
    {
      "country": "Vanuatu",
      "states": ["Malampa", "Penama", "Sanma", "Shefa", "Tafea", "Torba"]
    },
    {
      "country": "Venezuela",
      "states": ["Amazonas", "Anzoategui", "Apure", "Aragua", "Barinas", "Bolivar", "Carabobo", "Cojedes", "Delta Amacuro", "Dependencias Federales", "Distrito Federal", "Falcon", "Guarico", "Lara", "Merida", "Miranda", "Monagas", "Nueva Esparta", "Portuguesa", "Sucre", "Tachira", "Trujillo", "Vargas", "Yaracuy", "Zulia"]
    },
    {
      "country": "Vietnam",
      "states": ["An Giang", "Bac Giang", "Bac Kan", "Bac Lieu", "Bac Ninh", "Ba Ria-Vung Tau", "Ben Tre", "Binh Dinh", "Binh Duong", "Binh Phuoc", "Binh Thuan", "Ca Mau", "Cao Bang", "Dac Lak", "Dac Nong", "Dien Bien", "Dong Nai", "Dong Thap", "Gia Lai", "Ha Giang", "Hai Duong", "Ha Nam", "Ha Tay", "Ha Tinh", "Hau Giang", "Hoa Binh", "Hung Yen", "Khanh Hoa", "Kien Giang", "Kon Tum", "Lai Chau", "Lam Dong", "Lang Son", "Lao Cai", "Long An", "Nam Dinh", "Nghe An", "Ninh Binh", "Ninh Thuan", "Phu Tho", "Phu Yen", "Quang Binh", "Quang Nam", "Quang Ngai", "Quang Ninh", "Quang Tri", "Soc Trang", "Son La", "Tay Ninh", "Thai Binh", "Thai Nguyen", "Thanh Hoa", "Thua Thien-Hue", "Tien Giang", "Tra Vinh", "Tuyen Quang", "Vinh Long", "Vinh Phuc", "Yen Bai", "Can Tho", "Da Nang", "Hai Phong", "Hanoi", "Ho Chi Minh"]
    },
    {
      "country": "Yemen",
      "states": ["Abyan", "Adan", "Ad Dali", "Al Bayda", "Al Hudaydah", "Al Jawf", "Al Mahrah", "Al Mahwit", "Amran", "Dhamar", "Hadramawt", "Hajjah", "Ibb", "Lahij", "Marib", "Sadah", "Sana", "Shabwah", "Taizz"]
    },
    {
      "country": "Zambia",
      "states": ["Central", "Copperbelt", "Eastern", "Luapula", "Lusaka", "Northern", "North-Western", "Southern", "Western"]
    },
    {
      "country": "Zimbabwe",
      "states": ["Bulawayo", "Harare", "Manicaland", "Mashonaland Central", "Mashonaland East", "Mashonaland West", "Masvingo", "Matabeleland North", "Matabeleland South", "Midlands"]
    }
  ]
}';


$jsonString='[
   "Afghan",
   "Albanian",
   "Algerian",
   "American",
   "Andorran",
   "Angolan",
   "Antiguans",
   "Argentinean",
   "Armenian",
   "Australian",
   "Austrian",
   "Azerbaijani",
   "Bahamian",
   "Bahraini",
   "Bangladeshi",
   "Barbadian",
   "Barbudans",
   "Batswana",
   "Belarusian",
   "Belgian",
   "Belizean",
   "Beninese",
   "Bhutanese",
   "Bolivian",
   "Bosnian",
   "Brazilian",
   "British",
   "Bruneian",
   "Bulgarian",
   "Burkinabe",
   "Burmese",
   "Burundian",
   "Cambodian",
   "Cameroonian",
   "Canadian",
   "Cape Verdean",
   "Central African",
   "Chadian",
   "Chilean",
   "Chinese",
   "Colombian",
   "Comoran",
   "Congolese",
   "Costa Rican",
   "Croatian",
   "Cuban",
   "Cypriot",
   "Czech",
   "Danish",
   "Djibouti",
   "Dominican",
   "Dutch",
   "East Timorese",
   "Ecuadorean",
   "Egyptian",
   "Emirian",
   "Equatorial Guinean",
   "Eritrean",
   "Estonian",
   "Ethiopian",
   "Fijian",
   "Filipino",
   "Finnish",
   "French",
   "Gabonese",
   "Gambian",
   "Georgian",
   "German",
   "Ghanaian",
   "Greek",
   "Grenadian",
   "Guatemalan",
   "Guinea-Bissauan",
   "Guinean",
   "Guyanese",
   "Haitian",
   "Herzegovinian",
   "Honduran",
   "Hungarian",
   "I-Kiribati",
   "Icelander",
   "Indian",
   "Indonesian",
   "Iranian",
   "Iraqi",
   "Irish",
   "Israeli",
   "Italian",
   "Ivorian",
   "Jamaican",
   "Japanese",
   "Jordanian",
   "Kazakhstani",
   "Kenyan",
   "Kittian and Nevisian",
   "Kuwaiti",
   "Kyrgyz",
   "Laotian",
   "Latvian",
   "Lebanese",
   "Liberian",
   "Libyan",
   "Liechtensteiner",
   "Lithuanian",
   "Luxembourger",
   "Macedonian",
   "Malagasy",
   "Malawian",
   "Malaysian",
   "Maldivan",
   "Malian",
   "Maltese",
   "Marshallese",
   "Mauritanian",
   "Mauritian",
   "Mexican",
   "Micronesian",
   "Moldovan",
   "Monacan",
   "Mongolian",
   "Moroccan",
   "Mosotho",
   "Motswana",
   "Mozambican",
   "Namibian",
   "Nauruan",
   "Nepalese",
   "New Zealander",
   "Nicaraguan",
   "Nigerian",
   "Nigerien",
   "North Korean",
   "Northern Irish",
   "Norwegian",
   "Omani",
   "Pakistani",
   "Palauan",
   "Panamanian",
   "Papua New Guinean",
   "Paraguayan",
   "Peruvian",
   "Polish",
   "Portuguese",
   "Qatari",
   "Romanian",
   "Russian",
   "Rwandan",
   "Saint Lucian",
   "Salvadoran",
   "Samoan",
   "San Marinese",
   "Sao Tomean",
   "Saudi",
   "Scottish",
   "Senegalese",
   "Serbian",
   "Seychellois",
   "Sierra Leonean",
   "Singaporean",
   "Slovakian",
   "Slovenian",
   "Solomon Islander",
   "Somali",
   "South African",
   "South Korean",
   "Spanish",
   "Sri Lankan",
   "Sudanese",
   "Surinamer",
   "Swazi",
   "Swedish",
   "Swiss",
   "Syrian",
   "Taiwanese",
   "Tajik",
   "Tanzanian",
   "Thai",
   "Togolese",
   "Tongan",
   "Trinidadian or Tobagonian",
   "Tunisian",
   "Turkish",
   "Tuvaluan",
   "Ugandan",
   "Ukrainian",
   "Uruguayan",
   "Uzbekistani",
   "Venezuelan",
   "Vietnamese",
   "Welsh",
   "Yemenite",
   "Zambian",
   "Zimbabwean"
]';

        $jArr = json_decode($jsonString, true);
        
         foreach($jArr as $item){
              
             Nationality::create(['name' => $item ]);
         }
       
       
       dd("Done");
        
        $counter=1;
        foreach($jArr as $item){
  
            foreach($item as $city_item){
                
                $city_items = $city_item['states'];
                
            
                
           $country_id = Country::create(['name' => $city_item['country'] ])->first()->id;
           
              foreach($city_items as $single_city){
                  
                  //dd($single_city);
                      
              City::create(['country_id' => $counter , 'name' => $single_city ]);
                  }
                  
                  
                   $counter++;
              
            }
           
            
        }
        dd($jArr);
        
         dd("STOPPPPEEEED");
        
          $file = public_path('motoalldatas.csv');
          
          $customerArr = $this->csvToArray($file);
          $sames="";
          
          
            // foreach($customerArr as $item){
            //   $name = $item['Top speed'];
            //   $sames.=",".$name;
            //     if($name&&$name!=""){
                    
                    
            //         try {
            //   MotoTopSpeed::create(['name'=>$name]);
            //      } catch (\Exception $e) {
            //          }

            //     }
            // }
            
          
            
 
            
            $counter=0;
            
            foreach($customerArr as $item){
                    
            $counter++;
            
            //from 0 // to 10000
            
                
                if($counter>=30000 && $counter<40000){
            
                 $name = $item['Make'];
                  $make_id =  MotoEngineBrand::select('id')->where('name',$name)->first();
                   
                  if($make_id){
                      $make_id = $make_id->id;
                  }else {
                      dd("Make". $item['Make']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Model'];
                  $model_id =  MotoEngineModel::select('id')->where('name',$name)->first();
                   
                  if($model_id){
                      $model_id = $model_id->id;
                  }else {
                      dd("Model". $item['Model']. "  ".$counter);
                  }
                  
                  
                    $name = $item['Year of launch'];
                  $year_id =  MotoEngineYear::select('id')->where('name',$name)->first();
                   
                  if($year_id){
                      $year_id = $year_id->id;
                  }else {
                      dd("Year of launch". $item['Year of launch']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Category'];
                  $category_id =  MotoCategory::select('id')->where('name',$name)->first();
                   
                  if($category_id){
                      $category_id = $category_id->id;
                  }else {
                      dd("Category". $item['Category']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Displacement'];
                  $displacement_id =  MotoDisplacement::select('id')->where('name',$name)->first();
                   
                  if($displacement_id){
                      $displacement_id = $displacement_id->id;
                  }else {
                      dd("Displacement". $item['Displacement']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Engine details'];
                  $engine_details_id =  MotoEngineDetails::select('id')->where('name',$name)->first();
                   
                  if($engine_details_id){
                      $engine_details_id = $engine_details_id->id;
                  }else {
                      dd("Engine details". $item['Engine details']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Power'];
                  $power_id =  MotoPower::select('id')->where('name',$name)->first();
                   
                  if($power_id){
                      $power_id = $power_id->id;
                  }else {
                      dd("Power". $item['Power']. "  ".$counter);
                  }
                
                
                
                
                  $name = $item['Power RPM'];
                  $power_rpm_id =  MotoPowerRpm::select('id')->where('name',$name)->first();
                   
                  if($power_rpm_id){
                      $power_rpm_id = $power_rpm_id->id;
                  }else {
                      dd("Power RPM". $item['Power RPM']. "  ".$counter);
                  }
                  
                  
                  $name = $item['Torque'];
                  $torque_id =  MotoTorque::select('id')->where('name',$name)->first();
                   
                  if($torque_id){
                      $torque_id = $torque_id->id;
                  }else {
                      dd("Torque". $item['Torque']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Torque RPM'];
                  $torque_rpm_id =  MotoTorqueRpm::select('id')->where('name',$name)->first();
                   
                  if($torque_rpm_id){
                      $torque_rpm_id = $torque_rpm_id->id;
                  }else {
                      dd("Torque RPM". $item['Torque RPM']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Top speed'];
                  $top_speed_id =  MotoTopSpeed::select('id')->where('name',$name)->first();
                   
                  if($top_speed_id){
                      $top_speed_id = $top_speed_id->id;
                  }else {
                      dd("Top speed". $item['Top speed']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['0-100 km/h (0-62 mph)'];
                  $zero_hundred_id =  MotoZeroOne::select('id')->where('name',$name)->first();
                   
                  if($zero_hundred_id){
                      $zero_hundred_id = $zero_hundred_id->id;
                  }else {
                      dd("0-100 km/h (0-62 mph)". $item['0-100 km/h (0-62 mph)']. "  ".$counter);
                  }
                  
                  
                  
                  
                   $name = $item['Compression'];
                  $compression_id =  MotoCompression::select('id')->where('name',$name)->first();
                   
                  if($compression_id){
                      $compression_id = $compression_id->id;
                  }else {
                      dd("Compression". $item['Compression']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Bore x stroke'];
                  $stroke_id =  MotoStroke::select('id')->where('name',$name)->first();
                   
                  if($stroke_id){
                      $stroke_id = $stroke_id->id;
                  }else {
                      dd("Bore x stroke". $item['Bore x stroke']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Valves per cylinder'];
                  $valves_id =  MotoValvesPerCylinder::select('id')->where('name',$name)->first();
                   
                  if($valves_id){
                      $valves_id = $valves_id->id;
                  }else {
                      dd("Valves per cylinder". $item['Valves per cylinder']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Cooling system'];
                  $cooling_system_id =  MotoCoolingSystem::select('id')->where('name',$name)->first();
                   
                  if($cooling_system_id){
                      $cooling_system_id = $cooling_system_id->id;
                  }else {
                      dd("Cooling system". $item['Cooling system']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Gearbox'];
                  $gear_box_id =  MotoGearBox::select('id')->where('name',$name)->first();
                   
                  if($gear_box_id){
                      $gear_box_id = $gear_box_id->id;
                  }else {
                      dd("Gearbox". $item['Gearbox']. "  ".$counter);
                  }
                  
                  
                  
                   $name = $item['Transmission type'];
                  $transimission_id =  MotoTransmissionType::select('id')->where('name',$name)->first();
                   
                  if($transimission_id){
                      $transimission_id = $transimission_id->id;
                  }else {
                      dd("Transmission type". $item['Transmission type']. "  ".$counter);
                  }
                  
                  
                   $name = $item['Weight incl. oil, gas, etc'];
                  $weight_id =  MotoWeight::select('id')->where('name',$name)->first();
                   
                  if($weight_id){
                      $weight_id = $weight_id->id;
                  }else {
                      dd("Weight incl. oil, gas, etc". $item['Weight incl. oil, gas, etc']. "  ".$counter);
                  }
                  
                  
                   
        
     
              
              $car_stock=   MotoStock::create([
                  'make_id'=>$make_id
                 ,'model_id'=>$model_id
                 ,'year_id'=>$year_id
                 ,'category_id'=>$category_id
                 ,'displacement_id'=>$displacement_id
                 ,'engine_details_id'=>$engine_details_id
                 ,'power_id'=>$power_id
                 ,'power_rpm_id'=>$power_rpm_id
                 ,'torque_id'=>$torque_id
                 ,'torque_rpm_id'=>$torque_rpm_id
                 ,'top_speed_id'=>$top_speed_id
                 ,'zero_hundred_id'=>$zero_hundred_id
                 ,'compression_id'=>$compression_id
                 ,'stroke_id'=>$stroke_id
                 ,'valves_id'=>$valves_id
                 ,'cooling_system_id'=>$cooling_system_id
                 ,'gear_box_id'=>$gear_box_id,
                 'transimission_id'=>$transimission_id
                 ,'weight_id'=>$weight_id
                 
                 ]);
   
           
                
                             
               }
            }
        return "DONE";
    }
    
    
  

   public function csvToArray($filename = '', $delimiter = ',')
    {
        if (!file_exists($filename) || !is_readable($filename))
            return false;

        $header = null;
        $data = array();
        if (($handle = fopen($filename, 'r')) !== false)
        {
            while (($row = fgetcsv($handle, 1000, $delimiter)) !== false)
            {
                if (!$header)
                    $header = $row;
                else
                    $data[] = array_combine($header, $row);
            }
            fclose($handle);
        }

        return $data;
    }

}



