<?php

use App\Http\Controllers\Shipper\AdminLoginController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Shipper\ShipmentsController;
use App\Http\Controllers\Shipper\DriversController;
use App\Http\Controllers\Shipper\AdminsController;
use App\Http\Controllers\Shipper\RolesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::group([ 'middleware'=>'guest:shipper','prefix'=>'shipper'],function(){
    Route::get('login',[AdminLoginController::class , 'login'])->name('shipper.login');
    Route::post('submit-login',[AdminLoginController::class , 'submit_login'])->name('shipper.submit.login');
});

Route::group(['middleware'=>'auth:shipper','prefix'=>'shipper'],function(){
    Route::get('dashboard',[AdminLoginController::class , 'dashboard'])->name('shipper.dashboard');
    Route::get('logout',[AdminLoginController::class , 'logout'])->name('shipper.logout');
    Route::group(['as' => 'shipper.'],function(){
        Route::get('shipments/change/{shipment_id}',[ShipmentsController::class , 'change'])->name('shipments.change');

        Route::resource('shipments' , ShipmentsController::class);
        Route::resource('admins' , AdminsController::class);
        Route::resource('roles' , RolesController::class);
        Route::get('drivers/status/{driver_id}',[DriversController::class , 'status'])->name('drivers.status');
        Route::get('drivers/accept/{driver_id}',[DriversController::class , 'accept'])->name('drivers.accept');
        Route::resource('drivers' , DriversController::class);

    });






});

