<?php

use App\Http\Controllers\Api\Drivers\DriverAuthController;
use App\Http\Controllers\Api\Drivers\DriverProfileController;
use App\Http\Controllers\Api\Drivers\DriverRateController;
use App\Http\Controllers\Api\Drivers\DriverSettingController;
use App\Http\Controllers\Api\Drivers\DriverShipmentController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Users\NotificationController;
use App\Http\Controllers\Api\Users\MessageController;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(['prefix' => 'drivers'], function () {

    Route::group(['prefix' => 'auth'], function () {

         Route::get('countries', [DriverAuthController::class , 'list_countries']);
         Route::post('register', [DriverAuthController::class , 'register']);
         Route::post('verify-code', [DriverAuthController::class , 'verifyCode']);
         Route::get('get-data', [DriverAuthController::class , 'get_driver_data']);
         Route::post('update', [DriverAuthController::class , 'update_driver']);
         Route::post('login', [DriverAuthController::class , 'login']);
         Route::post('logout', [DriverAuthController::class , 'logout']);
         Route::post('forget-password', [DriverAuthController::class , 'forgetPassword']);
         Route::post('check-forget-code', [DriverAuthController::class , 'check_forget_code']);
         Route::post('reset-password', [DriverAuthController::class , 'resetPassword']);
         Route::get('generate-beams-token', [DriverAuthController::class , 'generateAuthToken']);
        Route::get('online-status/{status}', [DriverAuthController::class , 'onlineStatus']);
        Route::get('delete', [DriverAuthController::class, 'delete']);

    });


    Route::group(['prefix' => 'setting'], function () {

         Route::get('about-app', [DriverSettingController::class , 'list_about_app']);
         Route::get('list-terms-and-conditions', [DriverSettingController::class , 'list_terms_and_conditions']);
         Route::get('list-privacy-policy', [DriverSettingController::class , 'list_privacy_policy']);
         Route::post('technical-support', [DriverSettingController::class , 'technical_support']);
         Route::post('suggestions', [DriverSettingController::class , 'send_suggestion']);
    });
});

Route::group(['prefix' => 'drivers' ], function () {

    Route::group(['prefix' => 'shipment'], function () {

        Route::get('list', [DriverShipmentController::class , 'list_shipments']);
        Route::get('previous', [DriverShipmentController::class , 'previous_shipments']);
        Route::get('current', [DriverShipmentController::class , 'current_shipments']);
        Route::get('register-data', [DriverShipmentController::class , 'get_shipment_data']);
        Route::get('requests', [DriverShipmentController::class , 'shipment_requests']);
        Route::get('stop-requests',[DriverShipmentController::class , 'stop_requests']);
        Route::get('stop-requests-status',[DriverShipmentController::class , 'stop_requests_status']);
        Route::post('search',[DriverShipmentController::class , 'search']);
        Route::post('accept-price',[DriverShipmentController::class , 'accept_price']);
        Route::post('offer-price',[DriverShipmentController::class , 'offer_higher_price']);
        Route::post('choice-drivers',[DriverShipmentController::class , 'choice_drivers']);
        Route::post('reject-driver',[DriverShipmentController::class , 'reject_driver']);
        Route::post('change-status',[DriverShipmentController::class , 'change_status']);
        Route::get('details/{shipment_id}',[DriverShipmentController::class , 'get_shipment_details']);

     });

     Route::group(['prefix' => 'profile'], function () {

        Route::post('change-password', [DriverProfileController::class , 'change_password']);
        Route::post('update', [DriverProfileController::class , 'update_profile']);
        Route::post('update-truck', [DriverProfileController::class , 'update_truck']);
    });

    Route::group(['prefix' => 'rates'], function () {

        Route::get('/', [DriverRateController::class , 'my_rates']);
        Route::post('add-rate', [DriverRateController::class , 'add_rate']);
    });

   Route::group(['prefix' => 'messages'], function () {

        Route::get('/', [MessageController::class , 'driver_messages']);
        Route::post('/chat', [MessageController::class , 'driver_chat_messages']);
        Route::post('send', [MessageController::class , 'driver_send_message']);

    });

    Route::group(['prefix' => 'notifications'], function () {

        Route::get('/', [NotificationController::class , 'driver_notifications']);
    });

});

