@extends('shipper.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.drivers')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.drivers')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i
                                    class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close"
                                        data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>

                        @endforeach
                    @endif


                    <form action="{{route('shipper.drivers.store')}}" method="post"
                          enctype="multipart/form-data">
                        @csrf
                        <div class="row">


                            <div class="col-sm-12">


                                <div class="mb-3">
                                    <label for="formrow-firstname-input"
                                           class="form-label">   {{__('admin.name')}}  </label>
                                    <input type="text" required name="name" value="{{old('name')}}"
                                           autocomplete="off" class="form-control" id="formrow-firstname-input"
                                           placeholder="{{__('admin.name')}}">
                                </div>

                                <div class="mb-3">
                                    <label for="password" class="form-label">    {{__('admin.password')}}  </label>
                                    <input class="form-control" required name="password" type="password" id="password">
                                </div>
                                <div class="mb-3">
                                    <label for="mobile" class="form-label">    {{__('admin.phone')}}  </label>
                                    <input class="form-control" required name="mobile" value="{{old('mobile')}}"
                                           type="number" id="mobile">
                                </div>
                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="country_id">{{__('admin.country')}}</label>
                                        <select class="form-select form-control" name="country_id" id="country_id" required>
                                            <option selected disabled value="">{{__('admin.choose-country')}}</option>
                                            @if(count($countries)>0)
                                                @foreach($countries as $country)
                                                    <option value="{{$country->id}}">{{$country->name_ar}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="truck_id">{{__('admin.trucks')}}</label>
                                        <select class="form-select form-control" name="truck_id" id="truck_id" required>
                                            <option selected disabled value="">{{__('admin.choose-truck')}}</option>
                                            @if(count($trucks)>0)
                                                @foreach($trucks as $truck)
                                                    <option value="{{$truck->id}}">{{$truck->type->type_ar}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="identity_type">{{__('admin.identity_type')}}</label>
                                        <select class="form-select form-control" name="identity_type" id="identity_type" required>
                                            <option selected disabled
                                                    value="">{{__('admin.choose-identity_type')}}</option>
                                            <option value="identity_card">{{__('admin.identity_card')}}</option>
                                            <option value="passport" >{{__('admin.passport')}}</option>
                                            <option value="other"  >{{__('admin.other')}}</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="mb-3">
                                    <label for="identity_card_number"
                                           class="form-label">    {{__('admin.identity_card_number')}}  </label>
                                    <input class="form-control" name="identity_card_number"
                                           required value="{{old('identity_card_number')}}" type="number"
                                           id="identity_card_number">
                                </div>


                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="description" class="form-label">{{__('admin.location')}} <span class="text text-danger">*</span></label>

                                <input
                                    id="pac-input"
                                    class="form-control mb-2"
                                    type="text"
                                    name="address"
                                    placeholder="{{__('admin.area')}}"
                                    required
                                />

                                <input type="hidden" name="latitude" id="latitude" value="24.69200532495305">
                                <input type="hidden" name="longitude" id="longitude" value="46.71890947265625">

                                <div id="map" style="padding: 15%"></div>
                            </div>
                        </div>


                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.img')}}  </label>
                            <input class="form-control" type="file" name="profile_image" id="formFile" required>
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_identity_card_image')}}  </label>
                            <input class="form-control" type="file" name="front_identity_card_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_identity_card_image')}}  </label>
                            <input class="form-control" type="file" name="back_identity_card_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.passport_image')}}  </label>
                            <input class="form-control" type="file" name="passport_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.other_identity_image')}}  </label>
                            <input class="form-control" type="file" name="other_identity_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_license_image')}}  </label>
                            <input class="form-control" type="file" name="front_license_image" id="formFile" required>
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_license_image')}}  </label>
                            <input class="form-control" type="file" name="back_license_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_ownership_image')}}  </label>
                            <input class="form-control" type="file" name="front_ownership_image" id="formFile" required>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_ownership_image')}}  </label>
                            <input class="form-control" type="file" name="back_ownership_image" id="formFile" required>
                        </div>


                        <div class="d-flex flex-wrap gap-2">
                            <button type="submit"
                                    class="btn btn-primary waves-effect waves-light"> {{__('admin.add')}}</button>

                        </div>

                    </form>

                </div>
            </div>


        </div>
    </div>

    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDhnmMC23noePz6DA8iEvO9_yNDGGlEaeM&callback=initAutocomplete&v=weekly&libraries=places"
        async
    ></script>
    <script>
        function initAutocomplete() {
            const map = new google.maps.Map(document.getElementById("map"), {
                center: { lat: 24.69200532495305, lng: 46.71890947265625 },
                zoom: 13,
                mapTypeId: "roadmap",
            });
            // Create the search box and link it to the UI element.
            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);

            // map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            // Bias the SearchBox results towards current map's viewport.
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });

            let markers = [];

            // Listen for the event fired when the user selects a prediction and retrieve
            // more details for that place.
            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length == 0) {
                    return;
                }

                // Clear out the old markers.
                markers.forEach((marker) => {
                    marker.setMap(null);
                });
                markers = [];

                // For each place, get the icon, name and location.
                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        console.log("Returned place contains no geometry");
                        return;
                    }

                    $('#latitude').val(place.geometry.location.lat());
                    $('#longitude').val(place.geometry.location.lng());

                    const icon = {
                        url: place.icon,
                        size: new google.maps.Size(71, 71),
                        origin: new google.maps.Point(0, 0),
                        anchor: new google.maps.Point(17, 34),
                        scaledSize: new google.maps.Size(25, 25),
                    };

                    // Create a marker for each place.
                    markers.push(
                        new google.maps.Marker({
                            map,
                            icon,
                            title: place.name,
                            position: place.geometry.location,
                        })
                    );
                    if (place.geometry.viewport) {
                        // Only geocodes have viewport.
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });
                map.fitBounds(bounds);
            });
        }
        window.initAutocomplete = initAutocomplete;

    </script>

@endsection
