<!DOCTYPE html>
<html>
<head>
    <title>Delete Driver</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 500px;
            margin: 50px auto;
            padding: 20px;
        }
        .container {
            background: #f5f5f5;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 15px;
        }
        input {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            background: #dc3545;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
        }
        button:hover {
            background: #c82333;
        }
        .message {
            margin-top: 15px;
            padding: 10px;
            border-radius: 4px;
            display: none;
        }
        .success {
            background: #d4edda;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Delete Driver</h2>
    <div class="form-group">
        <label for="mobile">Phone Number:</label>
        <input type="tel" id="mobile" name="mobile" required>
    </div>
    <button onclick="deleteDriver()">Delete Driver</button>
    <div id="message" class="message"></div>
</div>

<script>
    function deleteDriver() {
        const mobile = document.getElementById('mobile').value;
        const messageDiv = document.getElementById('message');

        fetch('{{ route('drivers.delete') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ mobile: mobile })
        })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'block';
                if (data.message) {
                    messageDiv.className = 'message success';
                    messageDiv.textContent = data.message;
                } else {
                    messageDiv.className = 'message error';
                    messageDiv.textContent = data.error;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'block';
                messageDiv.className = 'message error';
                messageDiv.textContent = 'An error occurred';
            });
    }
</script>
</body>
</html>
