<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Rename the existing columns
            $table->renameColumn('title', 'title_ar');
            $table->renameColumn('body', 'body_ar');

            // Add new columns with default values set to the value of the renamed columns
            $table->string('title_en')->nullable();
            $table->string('body_en')->nullable();
        });

        // Copy the data from title_ar and body_ar to title_en and body_en
        DB::table('notifications')->update([
            'title_en' => DB::raw('title_ar'),
            'body_en' => DB::raw('body_ar')
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Reverse the renaming
            $table->renameColumn('title_ar', 'title');
            $table->renameColumn('body_ar', 'body');

            // Drop the new columns
            $table->dropColumn(['title_en', 'body_en']);
        });
    }
};
