<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->integer('sender_id');
            $table->string('sender_type');
            $table->integer('receiver_id');
            $table->string('receiver_type');
            $table->string('shipment_id')->nullable();
            $table->longText('message')->nullable();
            $table->string('image')->nullable();
            $table->timestamp('read_at')->nullable(); // will not use it now
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages');
    }
};
