<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('number_of_axles_id')
                ->default('0');


        });
        Schema::table('truck_types', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('type_ar')
                ->default('0');


        });
        Schema::table('truck_categories', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('category_ar')
                ->default('0');


        });
        Schema::table('truck_models', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('model')
                ->default('0');


        });
        Schema::table('truck_heights', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('height')
                ->default('0');


        });
        Schema::table('truck_widths', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('width')
                ->default('0');


        });
        Schema::table('truck_lengths', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('length')
                ->default('0');


        });
        Schema::table('truck_load_capacities', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('load_capacity')
                ->default('0');


        });
        Schema::table('truck_number_of_axles', function (Blueprint $table) {
            $table->string('kilo_price')
                ->after('number_of_axles')
                ->default('0');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
};
