<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipments', function (Blueprint $table) {
            $table->id();
            $table->string('type')->nullable();
            $table->decimal('weight');
            $table->enum('status',['packing_in_progress' ,'Packed' , 'in_delivery' , 'deliveried' ])->default('packing_in_progress');
            $table->text('description')->nullable();
            $table->integer('sender_id')->nullable();
            $table->integer('receiver_id')->nullable();
            $table->integer('driver_id')->nullable();
            $table->integer('truck_id')->nullable();
            $table->integer('from_address_id');
            $table->integer('from_address_detail_id');
            $table->integer('to_address_id');
            $table->integer('to_address_detail_id');
            $table->integer('number_of_trucks');
            $table->integer('insurance_type_id');
            $table->string('shipment_invoice_picture');
            $table->string('packing_list_picture');
            $table->boolean('accepted')->default(0);
            $table->decimal('user_price',8,2)->nullable();
            $table->decimal('driver_price',8,2)->nullable();
            $table->decimal('final_price',8,2)->nullable();
            $table->date('packing_date')->nullable();
            $table->time('packing_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shipments');
    }
};
