<?php

namespace App\Services\External;

use App\Modules\User\Models\User;
use App\Services\External\NotifyTo;

class Notification
{
    /**
     * Method a query to only notify users
     * @param  $notify_type
     * @param  $user_id
     * @param  $package_id
     * @param  $title
     * @param  $body
     * @return void
     */

    public static function notify(
        $user_type,
        $notify_type, $users_id,
        $target_id, $title, $body,
        $name = '', $message = '',
        $amount = 0,
        $messageObject = null): void {
        if (count($users_id) > 0) {
            foreach ($users_id as $user_id) {

                $data = [
                    'type' => $notify_type,
                    'title' => $title,
                    'body' => $body,
                    'sound' => 'default',
                    'message' => $message ? $message : null,

                ];

                NotifyTo::send($user_type, $user_id, $data);
            }
        }

    }
    public static function notifyFor(
        $interest,
        $title, $body): void {
        $data = [
            'type' => $interest,
            'target_id' => 0,
            'title' => $title,
            'body' => $body,
            'sound' => 'default',

        ];
        NotifyFor::send($interest, $data);

    }

}
