<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $guarded = ['id' , 'created_at','updated_at'];

    public function getTitleAttribute()
    {
        return $this->attributes['title_' . app()->getLocale()];
    }

    public function getBodyAttribute()
    {
        return $this->attributes['body_' . app()->getLocale()];
    }


    public function user()
    {
        return $this->belongsTo(User::class , 'user_id' ,'id');
    }
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->locale(app()->getLocale())->translatedFormat('H:i ,d M Y');
    }

}
