<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    use HasFactory;

    protected $fillable = [
        'sender_id',
        'sender_type',
        'receiver_id',
        'receiver_type',
        'shipment_id',
        'message',
        'image',
        'read_at',
    ];


    public function getImageAttribute($value){
//        dd(asset('images').'/');
        return  $value ? asset('images').'/'.  $value : null;
    }


    public function scopeBetweenPartners($query, $user1Id, $user1Type, $user2Id, $user2Type)
    {
        return $query->where(function ($query) use ($user1Id, $user1Type, $user2Id, $user2Type) {
            $query->where('sender_id', $user1Id)
                ->where('sender_type', $user1Type)
                ->where('receiver_id', $user2Id)
                ->where('receiver_type', $user2Type);
        })->orWhere(function ($query) use ($user1Id, $user1Type, $user2Id, $user2Type) {
            $query->where('sender_id', $user2Id)
                ->where('sender_type', $user2Type)
                ->where('receiver_id', $user1Id)
                ->where('receiver_type', $user1Type);
        });
    }


    public function scopeChatsForUser($query, $userId, $userType)
    {
        return $query->where(function ($query) use ($userId, $userType) {
            $query->where('sender_id', $userId)
                ->where('sender_type', $userType);
        })->orWhere(function ($query) use ($userId, $userType) {
            $query->where('receiver_id', $userId)
                ->where('receiver_type', $userType);
        });
    }
}
