<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FromAddressDetail extends Model
{
    use HasFactory;

    protected $fillable = [ 'country_id' , 'governorate_id' , 'city_id' , 'address_name' , 'street_name' , 'description','from_address_id'];

    public function country()
    {
        return $this->belongsTo(ShipmentCountry::class , 'country_id' ,'id');
    }

    public function governorate()
    {
        return $this->belongsTo(ShipmentGovernorate::class , 'governorate_id' ,'id');
    }

    public function city()
    {
        return $this->belongsTo(ShipmentCity::class , 'city_id' ,'id');
    }
}
