<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Models\DriverAddress;


class Driver extends Authenticatable implements JWTSubject
{
    use HasFactory, Notifiable;


    protected $fillable = [
        'name',
        'shipper_id',
        'status',
        'password',
        'mobile',
        'identity_type',
        'identity_card_number',
        'other_identity_type',
        'front_identity_card_image',
        'back_identity_card_image',
        'passport_image',
        'other_identity_image',
        'verification_code',
        'forget_code',
        'country_id',
        'stop_receiving_shipment_requests',
        'profile_image',
        'truck_id',
        'address_id',
        'front_license_image',
        'back_license_image',
        'front_ownership_image',
        'back_ownership_image',
        'accepted',
        'online'
    ];

//    public function getProfileImageAttribute($value){
////        dd(asset('images').'/');
//        return  asset('images').'/drivers/'.  $value;
//    }

    protected $hidden = [
        'password',
        'remember_token',
    ];


    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }


    public function getJWTCustomClaims()
    {
        return [];
    }


    public function messages()
    {
        return $this->belongsToMany(User::class , 'messages' , 'driver_id' ,'user_id' )->withPivot('message','image');
    }

    public function truck()
    {
        return $this->belongsTo(Truck::class , 'truck_id' , 'id' );
    }
    public function country()
    {
        return $this->belongsTo(Country::class , 'country_id' , 'id' );
    }

    public function address()
    {
        return $this->belongsTo(DriverAddress::class , 'address_id' , 'id' );
    }

    public function user_rates(){
        return $this->belongsToMany(User::class , 'rates','driver_id' , 'user_id' )->withPivot('rate','comment');
    }
    public function rates(){
        return $this->hasMany(Rate::class);
    }

   public function shipments(){
        return $this->belongsToMany(Shipment::class , 'shipment_drivers','driver_id' , 'shipment_id' )->withPivot('status');
    }

}
