<?php

namespace App\Http\Resources;

use App\Models\FromAddress;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'type' => $this->type,
            'weight' => $this->weight,
            'status' => $this->status,
            'description' => $this->description,
            'packing_date' => $this->packing_date,
            'packing_time' => $this->packing_time,
            'driver' => new DriverResource($this->driver),
            'sender' => new UserResource($this->sender),
            'user_price' => $this->user_price,
            'driver_price' => $this->driver_price,
            'final_price' => $this->final_price,
            'from_address'=> new AddressResource($this->from_address),
            'from_address details'=> new AddressDetailResource($this->from_address_details),
            'to_address'=> new AddressResource($this->to_address),
            'to_address detail'=> new AddressDetailResource($this->to_address_details),
            'receiver'=> new UserResource($this->receiver),
            'type'=> $this->type,
            'weight'=> $this->weight,
            'truck'=> new TruckResource($this->truck),
            'number_of trucks'=> $this->number_of_trucks,
            'insurance_type'=> new InsuranceTypeResource($this->insurance_type),
            'shipment_invoice_picture'=> $this->shipment_invoice_picture,
            'packing_list_picture'=> $this->packing_list_picture,
            'code'=> $this->code,

        ];
    }
}


