<?php

namespace App\Http\Resources;

use App\Models\FromAddress;
use Illuminate\Http\Resources\Json\JsonResource;

class ShipmentRequestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

              'id' => $this->id,
              'sender_name' => $this->sender->name ?? null,
              'sender_image' => asset('images/flags/').'/'. $this->sender->image ?? null,
              'sender_rate' => $this->sender->rate ?? null,
              'price' => $this->user_price ?? null,
              'packing_from' => $this->from_address_details->governorate->name_en  .'('.$this->from_address_details->country->name_en.')' ?? null,
              'packing_to' => $this->to_address_details->governorate->name_en .'('.$this->to_address_details->country->name_en.')' ?? null,
              'packing_date' => $this->packing_date . " - " . $this->packing_time ?? null,
        ];
    }
}


