<?php

namespace App\Http\Resources;

use App\Models\Driver;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;

class RateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $driver = Driver::where('id',$this->pivot->driver_id)->first();

        return [

            'driver' => $driver->name,
            'image' => asset('images/drivers/').'/'. $driver->profile_image,
            'rate' => $this->pivot->rate,
            'date' => date('d-m-Y', strtotime($this->created_at)),
            'comment' => $this->pivot->comment,
        ];
    }
}
