<?php

namespace App\Http\Resources;

use App\Models\Driver;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class MessageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $date = null;
        $carbonDate = Carbon::parse($this->created_at);
        if ($carbonDate->isToday()) {
            Carbon::setLocale('ar');
            $date = $carbonDate->diffForHumans();
        } else {
            $date = $carbonDate->format('d-m-Y');
        }

        return [

            'id' => $this->id,
            'sender_id' => $this->sender_id,
            'sender_type' => $this->sender_type,
            'sender_name' => $this->sender_type == 'user' ? User::find($this->sender_id)->name : Driver::find($this->sender_id)->name  ,
            'sender_image' => $this->sender_type == 'user' ? User::find($this->sender_id)->image : Driver::find($this->sender_id)->profile_image  ,
            'receiver_id' => $this->receiver_id,
            'receiver_type' => $this->receiver_type,
//            'receiver_object' => $this->receiver_type == 'user' ? new UserResource(User::find($this->receiver_id)) :new DriverResource(Driver::find($this->receiver_id))  ,

//            'driver' =>  Driver::where('id',$this->driver_id)->first()->name ?? null,
            'message' => $this->message ? $this->message : "",
            'image' => $this->image ? $this->image : "",
            'added_at' => $date,

        ];
    }
}
