<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DriverUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'front_license_image' => 'required|file|image',
            'back_license_image' => 'required|file|image',
            'front_ownership_image' => 'required|file|image',
            'back_ownership_image' => 'required|file|image',
            'number' => 'required|numeric',
            'color' => 'required',
            'type_id' => 'required|numeric|exists:truck_types,id',
            'catrgory_id' =>'required|numeric|exists:truck_categories,id',
            'model_id' =>'required|numeric|exists:truck_models,id',
            'length_id' =>'required|numeric|exists:truck_lengths,id',
            'width_id' =>'required|numeric|exists:truck_widths,id',
            'height_id' =>'required|numeric|exists:truck_heights,id',
            'load_capacity_id' =>'required|numeric|exists:truck_load_capacities,id',
            'number_of_axles_id' =>'required|numeric|exists:truck_number_of_axles,id',
            'longitude' => 'required',
            'latitude' => 'required',
        ];
    }
}
