<?php

namespace App\Http\Requests;

use App\Models\Driver;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DriverProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {

        return [
            'name' => 'required|min:2',
            'mobile' => [
                'required',
                Rule::unique('drivers')->where(function ($query) {
                    return $query->where('mobile', request()->mobile)
                        ->where('id', '!=', auth('driver')->user()->id);
                }),
            ],
        ];
    }
}
