<?php

namespace App\Http\Controllers\Shipper;

use App\Models\Driver;
use App\Models\Shipment;
use App\Models\Truck;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

class ShipmentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);
        $from = Carbon::parse($request->from)->toDateString();
        $to = Carbon::parse($request->to)->toDateString() ?? Carbon::now()->toDateString();

        $shipments = Shipment::orderBy('created_at', 'desc')
            ->when($request->user_id, function ($query) use ($request) {
                $query->where('sender_id', $request->user_id);
            })
            ->when(isset($request->status),function ($query)use($request){
                $query->where('status',$request->status);
            })
            ->when($request->driver_id, function ($query) use ($request) {
                $query->whereHas('drivers', function ($query) use ($request) {
                    $query->where(['shipment_drivers.driver_id' => $request->driver_id, 'shipment_drivers.status' => 1]);
                });
            })
            ->when($request->from && $request->to, function ($query) use ($from, $to) {
                $query->whereBetween('created_at', [$from, $to]);
            })
            ->whereHas('drivers', function ($query) {
                $query->where('drivers.shipper_id', auth()->guard('shipper')->id());
            })
            ->paginate();
        return view('shipper.pages.shipments.index', compact('shipments'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        $shipment=Shipment::whereId($id)->first();
        $drivers=Driver::where('shipper_id',auth()->guard('shipper')->id())->get();
        $trucks=Truck::whereHas('type')->get();

        return view('shipper.pages.shipments.show', compact('shipment','drivers','trucks'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(Request $request, $id)
    {

    }
    public function change(Request $request, $id)
    {
        $shipment=Shipment::whereId($id)->first();
        if($request->status){
            $shipment->update([
                'status'=>$request->status

            ]);
        }
        if($request->driver_id){
            $shipment->drivers()->attach([$request->driver_id=>['status'=>1]]);
        }
        if($request->truck_id){
            $shipment->update([
                'truck_id'=>$request->truck_id
            ]);
        }
        return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $shipment = Shipment::whereId($id)->first();
        $shipment->delete();
        return redirect()->route('shipper.shipments.index')->with('success', 'Deleted');

    }
}
