<?php

namespace App\Http\Controllers\Shipper;

use App\Http\Requests\Shipper\DriversRequest;
use App\Models\Country;
use App\Models\Driver;
use App\Models\DriverAddress;
use App\Models\Truck;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class DriversController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_users'), 403);
        $from=Carbon::parse($request->from)->toDateString();
        $to=Carbon::parse($request->to)->toDateString()??Carbon::now()->toDateString();

        $drivers=Driver::orderBy('created_at','desc')
            ->where('shipper_id',auth()->guard('shipper')->id())
            ->when(request()->accepted,function ($query){
                $query->where('accepted',0);
            })
            ->when(!request()->accepted,function ($query){
                $query->where('accepted',1);
            })
            ->when($request->from && $request->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })

            ->paginate();
        if(request()->accepted){
            return view('shipper.pages.drivers.requests',compact('drivers'));

        }
        return view('shipper.pages.drivers.index',compact('drivers'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $trucks=Truck::whereHas('type')->get();
        $countries=Country::all();

        return view('shipper.pages.drivers.create',compact('trucks','countries'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->hasFile('profile_image')){

            $profile_image = $request->file('profile_image');
            $profile_image_name = time() . '-' . $profile_image->getClientOriginalName();
            $profile_image->move(public_path().'/images/drivers', $profile_image_name);
        }

        if($request->hasFile('front_identity_card_image') && $request->hasFile('back_identity_card_image')){

            $front_identity_card_image = $request->file('front_identity_card_image');
            $front_file_name = time() . '-' . $front_identity_card_image->getClientOriginalName();
            $front_identity_card_image->move(public_path().'/images/drivers/front_identity_card_image', $front_file_name);

            $back_identity_card_image = $request->file('back_identity_card_image');
            $back_file_name = time() . '-' . $back_identity_card_image->getClientOriginalName();
            $back_identity_card_image->move(public_path().'/images/drivers/back_identity_card_image', $back_file_name);
        }

        if($request->hasFile('passport_image')){

            $passport_image = $request->file('passport_image');
            $passport_image_name = time() . '-' . $passport_image->getClientOriginalName();
            $passport_image->move(public_path().'/images/drivers/passport_image', $passport_image_name);
        }

        if($request->hasFile('other_identity_image')){

            $other_identity_image = $request->file('other_identity_image');
            $other_identity_image_name = time() . '-' . $other_identity_image->getClientOriginalName();
            $other_identity_image->move(public_path().'/images/drivers/other_identity_image', $other_identity_image_name);
        }
        if($request->hasFile('front_license_image')){

            $front_license_image = $request->file('front_license_image');
            $front_license_image_name = time() . '-' . $front_license_image->getClientOriginalName();
            $front_license_image->move(public_path().'/images/drivers/front_license_image', $front_license_image_name);
        }
        if($request->hasFile('back_license_image')){

            $back_license_image = $request->file('back_license_image');
            $back_license_image_name = time() . '-' . $back_license_image->getClientOriginalName();
            $back_license_image->move(public_path().'/images/drivers/back_license_image', $back_license_image_name);
        }
        if($request->hasFile('front_ownership_image')){

            $front_ownership_image = $request->file('front_ownership_image');
            $front_ownership_image_name = time() . '-' . $front_ownership_image->getClientOriginalName();
            $front_ownership_image->move(public_path().'/images/drivers/front_ownership_image', $front_ownership_image_name);
        }
        if($request->hasFile('back_ownership_image')){

            $back_ownership_image = $request->file('back_ownership_image');
            $back_ownership_image_name = time() . '-' . $back_ownership_image->getClientOriginalName();
            $back_ownership_image->move(public_path().'/images/drivers/back_ownership_image', $back_ownership_image_name);
        }
        $address = DriverAddress::create([
            'longitude' => $request->longitude,
            'latitude' => $request->latitude,
        ]);

        Driver::create([
            'country_id' => $request->country_id,
            'truck_id' => $request->truck_id,
            'name' => $request->name,
            'mobile' => $request->mobile,
            'password' => Hash::make($request->password),
            'identity_type' => $request->identity_type,
            'identity_card_number' => $request->identity_card_number,
            'other_identity_type' => $request->other_identity_type,
            'front_identity_card_image' => $front_file_name ?? null,
            'back_identity_card_image' => $back_file_name ?? null,
            'passport_image' => $passport_image_name ?? null,
            'other_identity_image' => $other_identity_image_name ?? null,
            'profile_image' => $profile_image_name ?? null,
            'verification_code' => 2222,
            'status'=>1,
            'accepted'=>1,
            'shipper_id'=>auth()->guard('shipper')->id(),
            'front_license_image'=>$front_license_image_name?? null,
            'back_license_image'=>$back_license_image_name?? null,
            'front_ownership_image'=>$front_ownership_image_name?? null,
            'back_ownership_image'=>$back_ownership_image_name?? null,
            'address_id'=>$address->id


        ]);

        return redirect()->route('shipper.drivers.index')->with('success','Added');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $driver=Driver::whereId($id)->with('shipments')->first();
        return view('shipper.pages.drivers.show',compact('driver'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
//        abort_if(Gate::denies('edit_users'), 403);

        $driver=Driver::whereId($id)->first();
        $countries=Country::all();
        $trucks=Truck::whereHas('type')->get();

        return view('shipper.pages.drivers.edit',compact('driver','countries','trucks'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(DriversRequest $request, $id)
    {
        $driver=Driver::whereId($id)->first();

        if($request->hasFile('profile_image')){

            $profile_image = $request->file('profile_image');
            $profile_image_name = time() . '-' . $profile_image->getClientOriginalName();
            $profile_image->move(public_path().'/images/drivers', $profile_image_name);
            $driver->update(['profile_image' => $profile_image_name]);

        }

        if($request->hasFile('front_identity_card_image') && $request->hasFile('back_identity_card_image')){

            $front_identity_card_image = $request->file('front_identity_card_image');
            $front_file_name = time() . '-' . $front_identity_card_image->getClientOriginalName();
            $front_identity_card_image->move(public_path().'/images/drivers/front_identity_card_image', $front_file_name);

            $back_identity_card_image = $request->file('back_identity_card_image');
            $back_file_name = time() . '-' . $back_identity_card_image->getClientOriginalName();
            $back_identity_card_image->move(public_path().'/images/drivers/back_identity_card_image', $back_file_name);
            $driver->update(['front_identity_card_image' => $front_file_name ,'back_identity_card_image' => $back_file_name]);

        }

        if($request->hasFile('passport_image')){

            $passport_image = $request->file('passport_image');
            $passport_image_name = time() . '-' . $passport_image->getClientOriginalName();
            $passport_image->move(public_path().'/images/drivers/passport_image', $passport_image_name);
            $driver->update(['passport_image' => $passport_image_name]);

        }

        if($request->hasFile('other_identity_image')){

            $other_identity_image = $request->file('other_identity_image');
            $other_identity_image_name = time() . '-' . $other_identity_image->getClientOriginalName();
            $other_identity_image->move(public_path().'/images/drivers/other_identity_image', $other_identity_image_name);

            $driver->update(['other_identity_image' => $other_identity_image_name]);

        }
        if($request->hasFile('front_license_image')){

            $front_license_image = $request->file('front_license_image');
            $front_license_image_name = time() . '-' . $front_license_image->getClientOriginalName();
            $front_license_image->move(public_path().'/images/drivers/front_license_image', $front_license_image_name);
            $driver->update(['front_license_image' => $front_license_image_name]);

        }
        if($request->hasFile('back_license_image')){

            $back_license_image = $request->file('back_license_image');
            $back_license_image_name = time() . '-' . $back_license_image->getClientOriginalName();
            $back_license_image->move(public_path().'/images/drivers/back_license_image', $back_license_image_name);
            $driver->update(['back_license_image'=>$back_license_image_name]);

        }
        if($request->hasFile('front_ownership_image')){

            $front_ownership_image = $request->file('front_ownership_image');
            $front_ownership_image_name = time() . '-' . $front_ownership_image->getClientOriginalName();
            $front_ownership_image->move(public_path().'/images/drivers/front_ownership_image', $front_ownership_image_name);
            $driver->update(['front_ownership_image'=>$front_ownership_image_name]);

        }
        if($request->hasFile('back_ownership_image')){

            $back_ownership_image = $request->file('back_ownership_image');
            $back_ownership_image_name = time() . '-' . $back_ownership_image->getClientOriginalName();
            $back_ownership_image->move(public_path().'/images/drivers/back_ownership_image', $back_ownership_image_name);
            $driver->update(['back_ownership_image'=>$back_ownership_image_name]);

        }
        if($request->latitude && $request->longitude){
            $driver->address->update([
                'longitude' => $request->longitude,
                'latitude' => $request->latitude,

            ]);
        }

        $driver->update($request->validated());

        if($request->password!=null){
            $driver->update(['password'=>Hash::make($request->password)]);
        }

        return redirect()->route('shipper.drivers.index')->with('success','Update');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_users'), 403);

        $driver=Driver::whereId($id)->first();

        $driver->delete();

        return redirect()->route('shipper.drivers.index')->with('success','Deleted');

    }
    public function status($id)
    {

        $driver=Driver::whereId($id)->first();
        $driver->update([
            'status'=>$driver->status==1?2:1
        ]);

        return redirect()->route('shipper.drivers.index')->with('success','Deleted');

    }
    public function accept($id)
    {

        $driver=Driver::whereId($id)->first();
        $driver->update([
            'accepted'=>1
        ]);

        return redirect()->route('shipper.drivers.index')->with('success','Accepted');

    }

}
