<?php

namespace App\Http\Controllers\Api\Drivers;

use App\Http\Controllers\Controller;
use App\Http\Requests\DriverRequest;
use App\Http\Requests\DriverUpdateRequest;
use App\Http\Requests\ResetPasswordRequest;
use App\Http\Resources\CountryResource;
use App\Http\Resources\DriverResource;
use App\Http\Resources\DriverUpdateResource;
use App\Http\Resources\TruckCategoryResource;
use App\Http\Resources\TruckHeightResource;
use App\Http\Resources\TruckLengthResource;
use App\Http\Resources\TruckLoadCapacityResource;
use App\Http\Resources\TruckModelResource;
use App\Http\Resources\TruckNumberOfAxlesResource;
use App\Http\Resources\TruckTypeResource;
use App\Http\Resources\TruckWidthResource;
use App\Models\Country;
use App\Models\Driver;
use App\Models\DriverAddress;
use App\Models\Truck;
use App\Models\TruckCategory;
use App\Models\TruckHeight;
use App\Models\TruckLength;
use App\Models\TruckLoadCapacity;
use App\Models\TruckModel;
use App\Models\TruckNumberOfAxles;
use App\Models\TruckType;
use App\Models\TruckWidth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Pusher\PushNotifications\PushNotifications;

class DriverAuthController extends Controller
{
    public function register(DriverRequest $request)
    {
        if($request->hasFile('profile_image')){

            $profile_image = $request->file('profile_image');
            $profile_image_name = time() . '-' . $profile_image->getClientOriginalName();
            $profile_image->move(public_path().'/images', $profile_image_name);
        }

        elseif($request->hasFile('front_identity_card_image') && $request->hasFile('back_identity_card_image')){

            $front_identity_card_image = $request->file('front_identity_card_image');
            $front_file_name = time() . '-' . $front_identity_card_image->getClientOriginalName();
            $front_identity_card_image->move(public_path().'/images', $front_file_name);

            $back_identity_card_image = $request->file('back_identity_card_image');
            $back_file_name = time() . '-' . $back_identity_card_image->getClientOriginalName();
            $back_identity_card_image->move(public_path().'/images', $back_file_name);
        }

        elseif($request->hasFile('passport_image')){

            $passport_image = $request->file('passport_image');
            $passport_image_name = time() . '-' . $passport_image->getClientOriginalName();
            $passport_image->move(public_path().'/images', $passport_image_name);
        }

        elseif($request->hasFile('other_identity_image')){

            $other_identity_image = $request->file('other_identity_image');
            $other_identity_image_name = time() . '-' . $other_identity_image->getClientOriginalName();
            $other_identity_image->move(public_path().'/images', $other_identity_image_name);
        }


        $driver = Driver::create([
            'country_id' => $request->country_id,
            'name' => $request->name,
            'mobile' => $request->mobile,
            'password' => Hash::make($request->password),
            'identity_type' => $request->identity_type,
            'identity_card_number' => $request->identity_card_number,
            'other_identity_type' => $request->other_identity_type,
            'front_identity_card_image' => $front_file_name ?? null,
            'back_identity_card_image' => $back_file_name ?? null,
            'passport_image' => $passport_image_name ?? null,
            'other_identity_image' => $other_identity_image_name ?? null,
            'profile_image' => $profile_image_name ?? null,
            'verification_code' => 2222,
            ]);


        $token = Auth::login($driver);
        $driver = new DriverResource(auth()->user());
        $truck =  $driver->truck;
        $driver['token'] = $token;
        $driver['truck'] =  $truck;

         return apiResponse(200, 'register is success', new DriverResource($driver));
    }





    public function verifyCode(Request $request)
    {
            if($request->code){
                $user = auth('driver')->user();
                if($user->verification_code == $request->code){

                return apiResponse(200 , 'code is valid' , null);
                      }
                return apiResponse(404 , 'code is invalid' , null);
                  }
    }

    public function get_driver_data()
    {
        try {

            $types = TruckType::get();
            $models = TruckModel::get();
            $categories = TruckCategory::get();
            $heights = TruckHeight::get();
            $widths = TruckWidth::get();
            $lengths = TruckLength::get();
            $loads = TruckLoadCapacity::get();
            $axles = TruckNumberOfAxles::get();


            return apiResponse(200 , null ,[

                'truck_types' => TruckTypeResource::collection($types),
                'truck_models' => TruckModelResource::collection($models),
                'truck_categories' => TruckCategoryResource::collection($categories),
                'truck_heights' => TruckHeightResource::collection($heights),
                'truck_width' => TruckWidthResource::collection($widths),
                'lengths' => TruckLengthResource::collection($lengths),
                'truck_load_capacity' => TruckLoadCapacityResource::collection($loads),
                'truck_number_of_axles' => TruckNumberOfAxlesResource::collection($axles),
            ]);

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }



    public function update_driver(Request $request)
    {

        $driver = auth('driver')->user();
        $type=TruckType::whereId($request->type_id)->first();
        $type=$type->kilo_price??0;
        $category=TruckCategory::whereId($request->catrgory_id)->first();
        $category=$category->kilo_price??0;
        $model=TruckModel::whereId($request->model_id)->first();
        $model=$model->kilo_price??0;
        $length=TruckLength::whereId($request->length_id)->first();
        $length=$length->kilo_price??0;
        $width=TruckWidth::whereId($request->width_id)->first();
        $width=$width->kilo_price??0;
        $height=TruckHeight::whereId($request->height_id)->first();
        $height=$height->kilo_price??0;
        $loadCapacity=TruckLoadCapacity::whereId($request->load_capacity_id)->first();
        $loadCapacity=$loadCapacity->kilo_price??0;
        $numberOfAxels= TruckNumberOfAxles::whereId($request->number_of_axles_id)->first();
        $numberOfAxels=$numberOfAxels->kilo_price??0;


            $truck = Truck::create([
            'number' => $request->number,
            'color' => $request->color,
            'type_id' => $request->type_id,
            'catrgory_id' => $request->catrgory_id,
            'model_id' => $request->model_id,
            'length_id' => $request->length_id,
            'width_id' => $request->width_id,
            'height_id' => $request->height_id,
            'load_capacity_id' => $request->load_capacity_id,
            'number_of_axles_id' => $request->number_of_axles_id,
            'kilo_price'=>($type+$category+$model+$length+$width+$height+$loadCapacity+$numberOfAxels)
        ]);

        $address = DriverAddress::create([
            'longitude' => $request->longitude,
            'latitude' => $request->latitude,
        ]);

        $truck['address_id'] = $address->id;

        return apiResponse(200 ,'profile is updated', new DriverUpdateResource( $truck));
    }


    public function save_truck_images(Request $request)
    {
            $driver = auth('driver')->user();

         if($request->hasFile('front_license_image') && $request->hasFile('back_license_image') && $request->hasFile('front_ownership_image') && $request->hasFile('back_ownership_image')){

            $front_license_image = $request->file('front_license_image');
            $front_license_image_name = time() . '-' . $front_license_image->getClientOriginalName();
            $front_license_image->move(public_path().'/images', $front_license_image_name);

            $back_license_image = $request->file('back_license_image');
            $back_license_image_name = time() . '-' . $back_license_image->getClientOriginalName();
            $back_license_image->move(public_path().'/images', $back_license_image_name);

            $front_ownership_image = $request->file('front_ownership_image');
            $front_ownership_image_name = time() . '-' . $front_ownership_image->getClientOriginalName();
            $front_ownership_image->move(public_path().'/images', $front_ownership_image_name);

            $back_ownership_image = $request->file('back_ownership_image');
            $back_ownership_image_name = time() . '-' . $back_ownership_image->getClientOriginalName();
            $back_ownership_image->move(public_path().'/images', $back_ownership_image_name);

            $driver->update([
                'truck_id' => $request->id,
                'address_id'=> $request->address_id,
                'front_license_image' => $front_license_image_name,
                'back_license_image' => $back_license_image_name,
                'front_ownership_image' => $front_ownership_image_name,
                'back_ownership_image' => $back_ownership_image_name,
            ]);
        }
                return apiResponse(200 ,'profile is updated',$driver);

    }



    public function login()
    {
            $credentials = request(['mobile', 'password']);

            if (! $token = auth('driver')->attempt($credentials)) {
                return apiResponse(401 , 'email or password are invalid', null);
            }

            return apiResponse(200 , 'login is success' , [
                'token' => $token,
                'user' => new DriverResource(auth('driver')->user()),
            ]);
    }

    public function logout()
    {
        auth('driver')->logout();
        return apiResponse(200 , 'Successfully logged out' ,null);
    }

    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60
        ]);
    }

    public function forgetPassword(Request $request)
    {
        try {
            $driver = Driver::where('mobile',$request->mobile)->first();
            if($driver){

                // $code = rand(1111,9999);
                $code = 1111;
                $driver->forget_code = $code;
                $driver->save();

             // send code to driver at mobile
             return apiResponse(200 , 'code is sent' , $code );
            }
            return apiResponse(404 , 'driver not found' , null );

        } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
        }
    }

    public function check_forget_Code(Request $request)
    {
        try {
            if($request->code){
                $driver = Driver::where('forget_code',$request->code)->first();

                if($driver){

                return apiResponse(200 , 'code is valid' , null);
                      }

                return apiResponse(404 , 'code is invalid' , null);
                  }

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
        }
    }


    public function resetPassword(ResetPasswordRequest $request)
    {
          try {
            $driver = Driver::where('forget_code',$request->code)->first();

            $driver->update([
                'password' => Hash::make($request->new_password),
            ]);

            return apiResponse(200 , 'password is updated' , null);

          } catch (\Throwable $th) {
            return apiResponse($th->getCode(), $th->getMessage() , null);
          }
    }

    public function list_countries()
    {
        try {
            $countries = Country::get();
            return apiResponse(200 ,null, CountryResource::collection($countries));

        } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
        }
    }
    public function generateAuthToken(Request $request)
    {
        $beamsClient = new PushNotifications(array(
            "instanceId" => config('services.Beams.Beams_Instance_Id'),
            "secretKey" => config('services.Beams.Beams_Secret_key')
        ));
        $beamsToken = $beamsClient->generateToken("drivers-".auth('driver')->user()->id);
        return response()->json($beamsToken);

    }
    public function onlineStatus($status)
    {

        $driver = auth('driver')->user();
        if (!$driver) {
            return apiResponse(404, 'driver not found', null);
        }

        $driver->update([
            'online' => $status
        ]);

        return apiResponse(200, 'Status is updated', null);
    }
//
//    public function delete(){
//        if (auth('driver')->user()){
//            auth('driver')->user()->delete();
//
//            return apiResponse(200, 'Driver deleted successfully', null);
//        }
//
//        return apiResponse(404, 'Driver not found', null);
//    }

}
