<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\SlidersRequest;
use App\Http\Resources\V100\CategoriesResource;
use App\Models\Category;
use App\Models\City;
use App\Models\Service;
use App\Models\Slider;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use phpseclib3\Crypt\RSA;

class SlidersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $sliders = Slider::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.pages.sliders.index', compact('sliders'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.pages.sliders.create');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(SlidersRequest $request)
    {
        Slider::create($request->validated());
        return redirect()->back()->with('success', __('admin.done-successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit(Slider $slider)
    {
        return view('admin.pages.sliders.edit', compact('slider'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(SlidersRequest $request, Slider $slider)
    {
            $slider->update($request->validated());
            return redirect()->back()->with('success', __('admin.done-successfully'));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return Response
     */
    public function destroy(Slider $slider)
    {
        $image_path = public_path() . '/uploads/img/sliders/' . $slider->getAttributes()['image'];
        if ($slider->getAttributes()['image'] != null && file_exists($slider->getAttributes()['image'])) {
            unlink($image_path);
        }

        $slider->delete();
        return redirect()->back()->with('success', __('admin.done-successfully'));

    }
}
