<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\ShippersRequest;
use App\Models\Shipper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Hash;

class ShippersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
//        abort_if(Gate::denies('all_admins'), 403);

        $shippers = Shipper::paginate();
        return view('admin.pages.shippers.index', compact('shippers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
//        abort_if(Gate::denies('create_admins'), 403);

        return view('admin.pages.shippers.create');


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(ShippersRequest $request)
    {
//        abort_if(Gate::denies('create_admins'), 403);

        $data = $request->validated();
        $data['password'] = Hash::make($request->password);

        $shipper = Shipper::create($data);
        $shipper->assignRole([8]);

        return redirect()->route('admin.shippers.index')->with('success', 'تم اضافة المؤسسة بنجاح');

    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {
       // abort_if(Gate::denies('edit_admins'), 403);

        $shipper = Shipper::whereId($id)->first();
        return view('admin.pages.shippers.edit', compact( 'shipper'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(ShippersRequest $request, $id)
    {
       // abort_if(Gate::denies('edit_admins'), 403);

        $shipper = Shipper::whereId($id)->first();
        $shipper->update($request->validated());
        if ($request->password != null) {

            $shipper->password = Hash::make($request->password);

        }
        $shipper->save();
        return redirect()->route('admin.shippers.index')->with('success', ' تم تعديل المؤسسة بنجاح');

    }
    public function destroy($id)
    {

        $shipper = Shipper::whereId($id)->first();
        $shipper->delete();
        return redirect()->route('admin.shippers.index')->with('success', ' تم مسح المؤسسة بنجاح');

    }
}
