<?php

namespace App\Http\Controllers\Admin;

use App\Models\Shipment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

class ShipmentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);
        $from=Carbon::parse($request->from)->toDateString();
        $to=Carbon::parse($request->to)->toDateString()??Carbon::now()->toDateString();

        $shipments = Shipment::orderBy('created_at', 'desc')
            ->when($request->user_id,function ($query)use($request){
                $query->where('sender_id',$request->user_id);
            })
            ->when($request->status,function ($query)use($request){
                $query->where('status',$request->status);
            })
            ->when($request->id,function ($query)use($request){
                $query->where('id',$request->id);
            })
            ->when($request->driver_id,function ($query)use($request){
                $query->whereHas('drivers',function ($query)use($request){
                    $query->where(['shipment_drivers.driver_id'=>$request->driver_id,'shipment_drivers.status'=>1]);
                });
            })
            ->when($request->from && $request->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })
            ->whereHas('drivers')
        ->paginate();
        return view('admin.pages.shipments.index', compact('shipments'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show(Shipment $shipment)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit(Shipment $shipment)
    {
        return view('admin.pages.shipments.edit',compact('shipment'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(Request $request, Shipment $shipment)
    {
        if($request->status)
        {
            $shipment->update([
                'status'=>$request->status
            ]);
            return redirect()->back()->with('success', 'Deleted');

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $shipment = Shipment::whereId($id)->first();
        $shipment->delete();
        return redirect()->route('admin.shipments.index')->with('success', 'Deleted');

    }
}
