<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Models\ShipmentCountry;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CountriesRequest;

class ShipmentCountriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $shipmentCountries = ShipmentCountry::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.shipment-country.index', compact('shipmentCountries'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.shipment-country.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(CountriesRequest $request)
    {
        $flag = $request->file('flag');
        $flag_name = time() . '-' . $flag->getClientOriginalName();
        $flag->move(public_path() . '/images/flags/', $flag_name);
        ShipmentCountry::create($request->validated() + ['flag' => $flag_name]);


        return redirect()->route('admin.shipment-country.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $shipmentCountry = ShipmentCountry::whereId($id)->first();
        return view('admin.pages.shipment-country.edit', compact('shipmentCountry'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(CountriesRequest $request, $id)
    {
        $shipmentCountry = ShipmentCountry::whereId($id)->first();
        $shipmentCountry->update($request->validated());

        if ($request->flag) {
            $flag = $request->file('flag');
            $flag_name = time() . '-' . $flag->getClientOriginalName();
            $flag->move(public_path() . '/images/flags/', $flag_name);
            $shipmentCountry->update(['flag' => $flag_name]);


        }

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $shipmentCountry = ShipmentCountry::whereId($id)->first();
        $shipmentCountry->delete();
        return redirect()->route('admin.shipment-country.index')->with('success', 'Deleted');

    }
}
