<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\HowSgipmentRequest;
use App\Models\HowShipment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class HowShipmentController extends Controller
{

    public function index(Request $request)
    {

        $how_shipments = HowShipment::paginate();
        return view('admin.pages.how-shipment.index', compact('how_shipments'));

    }


    public function create()
    {
        return view('admin.pages.how-shipment.create');
    }



    public function store(HowSgipmentRequest $request)
    {

        HowShipment::create(['text' => $request->text]);

        return redirect()->route('admin.how-shipment.index')->with('success', 'Added');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {

        $how_shipment = HowShipment::whereId($id)->first();
        return view('admin.pages.how-shipment.edit', compact('how_shipment'));

    }


    public function update(HowSgipmentRequest $request, $id)
    {
        $how_shipment = HowShipment::whereId($id)->first();
        $how_shipment->update($request->validated());

        return redirect()->back()->with('success', 'Updated');

    }


    public function destroy($id)
    {

        $how_shipment = HowShipment::whereId($id)->first();
        $how_shipment->delete();
        return redirect()->route('admin.how-shipment.index')->with('success', 'Deleted');

    }
}
