<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\AdminsRequest;
use App\Models\Admin;
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Gate;

class AdminsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        abort_if(Gate::denies('access_admins'), 403);

        $admins = Admin::where('id', '!=', Auth::guard('admin')->user()->id)->orderBy('created_at','desc')->with('roles')->get();
        return view('admin.pages.admins.index', compact('admins'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        abort_if(Gate::denies('create_admins'), 403);

        $allroles = Role::where('id', '!=', 1)->where('guard_name','admin')->get();
        return view('admin.pages.admins.create', compact('allroles'));


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(AdminsRequest $request)
    {
        abort_if(Gate::denies('create_admins'), 403);

        $data = $request->validated();
        $data['password'] = Hash::make($request->password);

        $admin = Admin::create($data);
        $admin->assignRole($request->role);

        return redirect()->route('admin.admins.index')->with('success', 'تم اضافة مدير بنجاح');

    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {
        abort_if(Gate::denies('edit_admins'), 403);

        $admin = Admin::whereId($id)->first();
        $roles = $admin->roles()->pluck('role_id')->toArray();

        $allroles = Role::where('id', '!=', 1)->where('guard_name','admin')->get();
        return view('admin.pages.admins.edit', compact('allroles', 'admin', 'roles'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(AdminsRequest $request, $id)
    {
        abort_if(Gate::denies('edit_admins'), 403);

        $admintoupdate = Admin::whereId($id)->first();
        $admintoupdate->update($request->validated());
        if ($request->password != null) {

            $admintoupdate->password = Hash::make($request->password);

        }
        if ($request->role) {
            $admintoupdate->roles()->sync($request->role);
        }
        $admintoupdate->save();
        return redirect()->route('admin.admins.index')->with('success', ' تم تعديل المدير بنجاح');

    }
    public function editProfile()
    {

        return view('admin.pages.admins.profile');

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function updateProfile(AdminsRequest $request)
    {
        abort_if(Gate::denies('edit_admins'), 403);

        $admintoupdate = auth('admin')->user();
        $admintoupdate->name = $request->name;
        $admintoupdate->email = $request->email;
        if ($request->password != null) {

            $admintoupdate->password = Hash::make($request->password);

        }
        $admintoupdate->save();
        return redirect()->back()->with('success', ' تم تعديل المدير بنجاح');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
        abort_if(Gate::denies('delete_admins'), 403);

        $oneadmintodelete = Admin::whereId($id)->first();
        $oneadmintodelete->delete();
        return redirect()->route('admin.admins.index')->with('success', ' تم مسح المدير بنجاح');

    }
}
